package com.bxm.component.tbk.order.timer;

import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.enums.TakeOutOrderSource;
import com.bxm.component.tbk.order.service.TakeOutOrderCommissionService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Calendar;

/**
 * 每个月美团订单结算
 * @Author: Gonzo
 * @date  2020-03-26 17:42
 * @since 1.6.1
 */
@Slf4j
@Component
@AllArgsConstructor
public class DuomaiMeituanOrderCommissionSettleMonthTask extends AbstractCronTask<String> {

    private final TakeOutOrderCommissionService takeOutOrderCommissionService;

    private final OrderTimerConfigProperties orderTimerConfigProperties;

    private final TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());
        try {

            Calendar calendar = Calendar.getInstance();
            // 月初
            calendar.set(Calendar.DAY_OF_MONTH, 1);
            // 提前一天 就是上个月月底了
            calendar.add(Calendar.DAY_OF_MONTH, -1);

            // 将三方已结算的订单进行结算
            takeOutOrderCommissionService.commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource.MEITUAN,
                    // 上一个月月底的截止时间
                    DateUtils.getDayEndTime(calendar.getTime()));

        } catch(Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }

        log.info("执行任务: {} 结束", taskName());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "每月美团订单结算返佣_" + tbkOpenOrderProperties.getSite();
    }

    @Override
    public String cron() {
        if (log.isDebugEnabled()) {
            log.debug("{}: {}", taskName(), orderTimerConfigProperties.getDuomaiMeituanOrderCommissionSettleMonthCron());
        }

        return orderTimerConfigProperties.getDuomaiMeituanOrderCommissionSettleMonthCron();
    }
}
