package com.bxm.component.tbk.order.model.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class RefundResponse {

    /**
     * 订单结算时间
     */
    @JSONField(name = "earning_time")
    private Date earningTime;

    /**
     * 维权金额
     */
    @JSONField(name = "refund_fee")
    private BigDecimal refundFee;

    /**
     * 维权创建(淘客结算回执) 4,维权成功(淘客结算回执) 2,维权失败(淘客结算回执) 3,发生多次维权，待处理 11,
     * 从淘客处补扣（钱已结给淘客） 等待扣款 12,从淘客处补扣（钱已结给淘客） 扣款成功 13,从卖家处补扣（钱已结给卖家） 等待扣款 14,
     * 从卖家处补扣（钱已结给卖家） 扣款成功 15
     */
    @JSONField(name = "refund_status")
    private Integer refundStatus;

    /**
     * 1 表示2方，2表示3方
     */
    @JSONField(name = "refund_type")
    private int refundType;

    /**
     * 渠道关系id
     */
    @JSONField(name = "relation_id")
    private String relationId;

    /**
     * 会员关系id
     */
    @JSONField(name = "special_id")
    private String specialId;

    /**
     * 宝贝标题
     */
    @JSONField(name = "tb_auction_title")
    private String tbAuctionTitle;

    /**
     * 订单创建时间
     */
    @JSONField(name = "tb_trade_create_time")
    private Date tbTradeCreateTime;

    /**
     * 结算金额
     */
    @JSONField(name = "tb_trade_finish_price")
    private BigDecimal tbTradeFinishPrice;

    /**
     * 淘宝子订单编号
     */
    @JSONField(name = "tb_trade_id")
    private String tbTradeId;

    /**
     * 淘宝订单编号
     */
    @JSONField(name = "tb_trade_parent_id")
    private String tbTradeParentId;

    /**
     * 第二方应该返还的佣金(不包括技术服务费)
     */
    @JSONField(name = "tk_commission_fee_refund_pub")
    private BigDecimal tkCommissionFeeRefundPub;

    /**
     * 推广者memberid
     */
    @JSONField(name = "tk_pub_id")
    private String tkPubId;

    /**
     * 应返商家金额(二方)
     */
    @JSONField(name = "tk_pub_show_return_fee")
    private BigDecimal tkPubShowReturnFee;

    /**
     * 维权完成时间
     */
    @JSONField(name = "tk_refund_suit_time")
    private Date tkRefundSuitTime;

    /**
     * 维权创建时间
     */
    @JSONField(name = "tk_refund_time")
    private Date tkRefundTime;

    /**
     * 第二方应该返还的补贴(不包括技术服务费)
     */
    @JSONField(name = "tk_subsidy_fee_refund_pub")
    private BigDecimal tkSubsidyFeeRefundPub;

    /**
     * Number
     * 第三方推广者memberid
     */
    @JSONField(name = "tk3rd_pub_id")
    private String tk3rdPubId;

    /**
     * 	String
     * 	第三方应该返还的补贴
     */
    @JSONField(name = "tk_subsidy_fee_refund3rd_pub")
    private BigDecimal tkSubsidyFeeRefund3rdPub;

    /**
     * 	String
     * 	第三方应该返还的佣金
     */
    @JSONField(name = "tk_commission_fee_refund3rd_pub")
    private BigDecimal tkCommissionFeeRefund3rdPub;

    /**
     * 	String
     * 	应返商家金额(三方)
     */
    @JSONField(name = "tk3rd_pub_show_return_fee")
    private BigDecimal tk3rdPubShowReturnFee;

    /**
     * 	String
     * 	（口碑订单）口碑父订单号
     */
    @JSONField(name = "alsc_pid")
    private String alscPid;

    /**
     * 	String
     * 	（口碑订单）口碑子订单号
     */
    @JSONField(name = "alsc_id")
    private String alscId;
}
