package com.bxm.component.tbk.order.model.enums;

import java.util.Objects;

/**
 * 平台订单状态
 *
 * @author donghy
 */
public enum OrderStatusEnum {

    /**
     * 待结算
     */
    UNSETTLED(0, "待结算"),
    /**
     * 已结算
     */
    HAVE_SETTLED(1, "已结算"),
    /**
     * 已失效
     */
    INVALID(2, "已失效"),
    /**
     * 待支付
     */
    UNPAY(3,"待支付"),
    /**
     * 超时未支付
     */
    TIMEOUT_PAY(4,"超时未支付"),
    /**
     * 取消支付
     */
    CANCLE_PAY(5,"取消支付"),
    /**
     * 支付成功
     */
    SUCCESS_PAY(6,"成功支付"),
    /**
     * 核销成功
     */
    VERIFICATION_PAY(7,"核销成功"),
    /**
     * 退单中
     */
    REFUNDING(8,"退单中"),
    /**
     * 退单成功
     */
    REFUND_SUCCESS(9,"退单成功"),
    /**
     * 拒绝退单后变成待核销
     */
    REFUND_REFUSE(10,"拒绝退单待核销"),

    ;


    OrderStatusEnum(Integer status, String description) {
        this.status = status;
        this.description = description;
    }

    /**
     * 订单状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String description;

    public Integer getStatus() {
        return status;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 根据淘宝订单状态获取自身订单状态
     *
     * @param tbOrderStatus 淘宝订单状态
     * @return 返回平台订单状态
     */
    public static Integer getOrderStatus(Integer tbOrderStatus) {
        if (TbkOrderStatusEnum.INVALID.getStatus().equals(tbOrderStatus)) {
            return INVALID.getStatus();
        }

        return UNSETTLED.getStatus();
    }

    /**
     * 是否失效订单
     * @param orderStatus 订单状态
     * @return true-失效订单
     */
    public static boolean isInvalidOrder(Integer orderStatus) {

        return Objects.nonNull(orderStatus) && INVALID.getStatus().equals(orderStatus);
    }

}
