/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.order.service.impl;

import com.bxm.component.tbk.order.api.TbkOrderApi;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.dto.TbkOrderInfo;
import com.bxm.component.tbk.order.model.dto.TbkOrderPageInfo;
import com.bxm.component.tbk.order.model.enums.OrderTypeEnum;
import com.bxm.component.tbk.order.model.enums.TbkOrderType;
import com.bxm.component.tbk.order.service.EleTakeOutOrderService;
import com.bxm.newidea.component.JSON;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractEleTakeOutOrderService
implements EleTakeOutOrderService {
    private static final Logger log = LoggerFactory.getLogger(AbstractEleTakeOutOrderService.class);
    @Autowired
    private TbkOrderApi tbOrderService;
    @Autowired
    protected TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    public boolean syncOrder(TbkOrderInfo orderInfo) {
        try {
            log.info("\u5904\u7406\u997f\u4e86\u4e48\u8ba2\u5355: {}, siteId: {}\u8ba2\u5355\u6570\u636e: {} ", new Object[]{orderInfo.getOrderSn(), orderInfo.getSiteId(), JSON.toJSONString((Object)orderInfo)});
            return this.doSyncOrder(orderInfo);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u997f\u4e86\u4e48\u8ba2\u5355\u4fe1\u606f\u51fa\u9519 orderInfo: {}", (Object)JSON.toJSONString((Object)orderInfo), (Object)e);
            return false;
        }
    }

    @Override
    public void syncOrderStatusDays() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.minusDays(3L);
        start = LocalDateTime.of(start.getYear(), start.getMonth(), start.getDayOfMonth(), 0, 0, 0, 0);
        LocalDateTime end = now.minusDays(1L);
        end = LocalDateTime.of(end.getYear(), end.getMonth(), end.getDayOfMonth(), 23, 59, 59, 999999999);
        while (start.isBefore(end)) {
            LocalDateTime localDateTime = start;
            start = start.plusMinutes(20L);
            this.syncOrderStatus(localDateTime, start);
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                log.error("\u963b\u585e\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public void syncOrderStatus(LocalDateTime orderStartTime, LocalDateTime orderEndTime) {
        TbkOrderPageInfo<TbkOrderInfo> tbOrderPageInfo;
        Long pageNo = 1L;
        String positionIndex = null;
        do {
            log.info("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f: orderStartTime :{} orderEndTime: {}, pageNo: {} positionIndex: {}", new Object[]{orderStartTime, orderEndTime, pageNo, positionIndex});
            tbOrderPageInfo = this.tbOrderService.pullOrderNew(pageNo, (Long)20L, positionIndex, orderStartTime, orderEndTime, OrderTypeEnum.CHANNEL_ORDER.getCode(), this.tbkOpenOrderProperties.getSite());
            if (Objects.isNull(tbOrderPageInfo)) break;
            if (!CollectionUtils.isEmpty(tbOrderPageInfo.getList())) {
                tbOrderPageInfo.getList().stream().filter(p -> Objects.equals(p.getTbOrderType(), TbkOrderType.ELE.getType())).filter(p -> Objects.equals(p.getSiteId(), this.tbkOpenOrderProperties.getBusinessSiteId())).forEach(this::syncOrder);
            }
            positionIndex = tbOrderPageInfo.getPositionIndex();
            pageNo = tbOrderPageInfo.getPageNo();
        } while (tbOrderPageInfo.getHasNext().booleanValue());
    }

    protected abstract boolean doSyncOrder(TbkOrderInfo var1);
}

