/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.order.service.impl;

import com.bxm.component.tbk.order.api.TbkOrderApi;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.resp.RefundResponse;
import com.bxm.component.tbk.order.service.OrderRefundService;
import com.bxm.newidea.component.JSON;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractOrderRefundService
implements OrderRefundService {
    private static final Logger log = LoggerFactory.getLogger(AbstractOrderRefundService.class);
    @Autowired
    private TbkOrderApi tbOrderService;
    @Autowired
    private TbkOpenOrderProperties tbOpenOrderProperties;

    @Override
    public void pullRefundOrderDays() {
        LocalDateTime startDateTime = LocalDateTime.now();
        this.pullRefundOrder(startDateTime.minusDays(1L));
    }

    @Override
    public void pullRefundOrder(LocalDateTime startDateTime) {
        log.info("\u62c9\u53d6\u7ef4\u6743\u8ba2\u5355 \u5f00\u59cb startDateTime: {}", (Object)startDateTime);
        try {
            LocalDateTime now = LocalDateTime.now();
            while (now.isAfter(startDateTime)) {
                long i = 0L;
                while (true) {
                    log.info("\u62c9\u53d6\u7ef4\u6743\u8ba2\u5355 \u672c\u6b21\u67e5\u8be2\u65f6\u95f4: {} \u9875\u6570: {}", (Object)startDateTime, (Object)i);
                    List<RefundResponse> results = this.tbOrderService.pullRefundOrder(this.tbOpenOrderProperties.getQueryPageSize(), (Long)1L, (Long)1L, (Long)(++i), (Long)1L, startDateTime, this.tbOpenOrderProperties.getSite());
                    if (CollectionUtils.isEmpty(results)) break;
                    results.forEach(this::handleRefundOrder);
                }
                startDateTime = startDateTime.plusDays(1L);
            }
        }
        catch (Exception e) {
            log.error("\u62c9\u53d6\u7ef4\u6743\u8ba2\u5355\u51fa\u73b0\u9519\u8bef : {}", (Object)startDateTime, (Object)e);
        }
    }

    private void handleRefundOrder(RefundResponse response) {
        try {
            log.info("\u5904\u7406\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f: {}", (Object)response.getTbTradeId());
            this.doHandleRefundOrder(response);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u9000\u6b3e\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)response), (Object)e);
        }
    }

    protected abstract void doHandleRefundOrder(RefundResponse var1);
}

