package com.bxm.component.test.config;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;

import java.util.Objects;
import java.util.Properties;

/**
 * @author Gonzo
 * @date 2019-11-11 11:03
 */
public class JUnitTestSpringApplicationRunListener implements SpringApplicationRunListener {

    private final SpringApplication application;

    private final String[] args;

    private final SimpleApplicationEventMulticaster initialMulticaster;

    private Logger logger = LoggerFactory.getLogger(getClass());

    public JUnitTestSpringApplicationRunListener(SpringApplication application, String[] args) {
        this.application = application;
        this.args = args;
        this.initialMulticaster = new SimpleApplicationEventMulticaster();
        for (ApplicationListener<?> listener : application.getListeners()) {
            this.initialMulticaster.addApplicationListener(listener);
        }
    }

    @Override
    public void starting() {
        // 这个时候logger还未初始化完成，只能用控制台输出。。

        String env = System.getProperty("env");
        System.out.println(StringUtils.join("加载环境变量env: ", env));

        if (StringUtils.isBlank(env)) {
            System.setProperty("env", "LOCAL");
            System.out.println("环境变量env不存在，设置为LOCAL，单元测试环境。");
        }
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        String env = System.getProperty("env");

        if (StringUtils.isBlank(env) || Objects.equals(env, "LOCAL")) {

            logger.info("配置单元测试环境，禁用 eureka 等组件");

            MutablePropertySources propertySources = environment.getPropertySources();

            Properties p = new Properties();
            p.put("spring.freemarker.check-template-location", "false");
            p.put("eureka.client.enabled", "false");
            // 自定义上下线关闭
            p.put("spring.cloud.service-registry.auto-registration.enabled", "false");
            // 自定义 shutdown 组件关闭
            p.put("component.spring.custom-shutdown-hook.enabled", "false");

            propertySources.addFirst(new PropertiesPropertySource("junitProperties", p));
        }
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void started(ConfigurableApplicationContext context) {

    }

    @Override
    public void running(ConfigurableApplicationContext context) {

    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {

    }
}
