/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.cb;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import org.thunlp.thulac.cb.AlphaBeta;
import org.thunlp.thulac.cb.CBModel;
import org.thunlp.thulac.cb.CBNGramFeature;
import org.thunlp.thulac.cb.Node;
import org.thunlp.thulac.data.Dat;
import org.thunlp.thulac.data.POCGraph;
import org.thunlp.thulac.data.TaggedWord;

public class CBTaggingDecoder {
    private int maxLength = 20000;
    private int len = 0;
    private String sequence = "";
    private int[][] allowedLabelLists = new int[this.maxLength][];
    private int[][] pocsToTags = null;
    private CBNGramFeature nGramFeature = null;
    private Dat dat = null;
    private CBModel model = null;
    private Node[] nodes = new Node[this.maxLength];
    private int[] values;
    private AlphaBeta[] alphas = null;
    private int[] result;
    private String[] labelInfo;
    private int[][] labelTransPre = null;
    private int[][] labelTransPost = null;
    public int threshold = 0;

    public void loadFiles(String modelFile, String datFile, String labelFile) throws IOException {
        int i;
        String line;
        this.model = new CBModel(modelFile);
        this.values = new int[this.maxLength * this.model.l_size];
        this.alphas = new AlphaBeta[this.maxLength * this.model.l_size];
        this.result = new int[this.maxLength * this.model.l_size];
        for (int i2 = 0; i2 < this.maxLength; ++i2) {
            this.nodes[i2] = new Node();
            int[] pre = new int[]{i2 - 1, -1};
            this.nodes[i2].predecessors = pre;
            pre = new int[]{i2 + 1, -1};
            this.nodes[i2].successors = pre;
        }
        this.dat = new Dat(datFile);
        this.nGramFeature = new CBNGramFeature(this.dat, this.model, this.values);
        this.labelInfo = new String[10000];
        Vector pocTags = new Vector();
        for (int i3 = 0; i3 < 16; ++i3) {
            pocTags.add(new Vector());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(labelFile)));
        int ind = 0;
        while ((line = in.readLine()) != null) {
            this.labelInfo[ind] = line;
            int segInd = line.charAt(0) - 48;
            for (int j = 0; j < 16; ++j) {
                if ((1 << segInd & j) == 0) continue;
                ((Vector)pocTags.get(j)).add(ind);
            }
            ++ind;
        }
        in.close();
        this.pocsToTags = new int[16][];
        for (int j = 1; j < 16; ++j) {
            this.pocsToTags[j] = new int[((Vector)pocTags.get(j)).size() + 1];
            for (int k = 0; k < ((Vector)pocTags.get(j)).size(); ++k) {
                this.pocsToTags[j][k] = (Integer)((Vector)pocTags.get(j)).get(k);
            }
            this.pocsToTags[j][((Vector)pocTags.get((int)j)).size()] = -1;
        }
        int[][] labelLookingFor = new int[this.model.l_size][];
        for (i = 0; i < this.model.l_size; ++i) {
            labelLookingFor[i] = null;
        }
        block7: for (i = 0; i < this.model.l_size; ++i) {
            if ("30".indexOf(this.labelInfo[i].charAt(0)) != -1) continue;
            for (int j = 0; j <= i; ++j) {
                if (!this.labelInfo[i].substring(1).equals(this.labelInfo[j].substring(1)) || this.labelInfo[j].charAt(0) != '0') continue;
                if (labelLookingFor[j] == null) {
                    labelLookingFor[j] = new int[2];
                    labelLookingFor[j][0] = -1;
                    labelLookingFor[j][1] = -1;
                }
                labelLookingFor[j][this.labelInfo[i].charAt((int)0) - 49] = i;
                continue block7;
            }
        }
        for (i = 0; i < this.maxLength; ++i) {
            this.allowedLabelLists[i] = null;
        }
    }

    public void dp() {
        if (this.allowedLabelLists[0] == null) {
            this.allowedLabelLists[0] = this.pocsToTags[9];
        }
        if (this.allowedLabelLists[this.len - 1] == null) {
            this.allowedLabelLists[this.len - 1] = this.pocsToTags[12];
        }
        AlphaBeta.dbDecode(this.model.l_size, this.model.ll_weights, this.len, this.nodes, this.values, this.alphas, this.result, this.labelTransPre, this.allowedLabelLists);
        this.allowedLabelLists[0] = null;
        this.allowedLabelLists[this.len - 1] = null;
    }

    public void setLabelTrans() {
        int j;
        int i;
        int lSize = this.model.l_size;
        Vector preLabels = new Vector();
        Vector postLabels = new Vector();
        for (i = 0; i < lSize; ++i) {
            preLabels.add(new Vector());
            postLabels.add(new Vector());
        }
        for (i = 0; i < lSize; ++i) {
            for (j = 0; j < lSize; ++j) {
                int ni = this.labelInfo[i].charAt(0) - 48;
                int nj = this.labelInfo[j].charAt(0) - 48;
                boolean iIsEnd = ni == 2 || ni == 3;
                boolean jIsBegin = nj == 0 || nj == 3;
                boolean sameTag = this.labelInfo[i].substring(1).equals(this.labelInfo[j].substring(1));
                if (sameTag) {
                    if (!(ni == 0 && nj == 1 || ni == 0 && nj == 2 || ni == 1 && nj == 2 || ni == 1 && nj == 1 || ni == 2 && nj == 0 || ni == 2 && nj == 3 || ni == 3 && nj == 3) && (ni != 3 || nj != 0)) continue;
                    ((Vector)preLabels.get(j)).add(i);
                    ((Vector)postLabels.get(i)).add(j);
                    continue;
                }
                if (!iIsEnd || !jIsBegin) continue;
                ((Vector)preLabels.get(j)).add(i);
                ((Vector)postLabels.get(i)).add(j);
            }
        }
        this.labelTransPre = new int[lSize][];
        for (i = 0; i < lSize; ++i) {
            this.labelTransPre[i] = new int[((Vector)preLabels.get(i)).size() + 1];
            for (j = 0; j < ((Vector)preLabels.get(i)).size(); ++j) {
                this.labelTransPre[i][j] = (Integer)((Vector)preLabels.get(i)).get(j);
            }
            this.labelTransPre[i][((Vector)preLabels.get((int)i)).size()] = -1;
        }
        this.labelTransPost = new int[lSize][];
        for (i = 0; i < lSize; ++i) {
            this.labelTransPost[i] = new int[((Vector)postLabels.get(i)).size() + 1];
            for (j = 0; j < ((Vector)postLabels.get(i)).size(); ++j) {
                this.labelTransPost[i][j] = (Integer)((Vector)postLabels.get(i)).get(j);
            }
            this.labelTransPost[i][((Vector)postLabels.get((int)i)).size()] = -1;
        }
    }

    public void putValues() {
        if (this.len == 0) {
            return;
        }
        for (int i = 0; i < this.len; ++i) {
            this.nodes[i].type = 0;
        }
        ++this.nodes[0].type;
        this.nodes[this.len - 1].type += 2;
        int size = this.len * this.model.l_size;
        for (int i = 0; i < size; ++i) {
            this.values[i] = 0;
        }
        this.nGramFeature.putValues(this.sequence, this.len);
    }

    public boolean segment(String raw, POCGraph graph, List<TaggedWord> ts) {
        int i;
        if (raw.length() == 0) {
            return false;
        }
        for (i = 0; i < raw.length(); ++i) {
            this.allowedLabelLists[i] = this.pocsToTags[(Integer)graph.get(i) == 0 ? 15 : (Integer)graph.get(i)];
        }
        this.sequence = "";
        for (i = 0; i < raw.length(); ++i) {
            this.sequence = this.sequence + raw.charAt(i);
        }
        this.len = raw.length();
        this.putValues();
        this.dp();
        for (i = 0; i < raw.length(); ++i) {
            this.allowedLabelLists[i] = null;
        }
        int offset = 0;
        ts.clear();
        for (int i2 = 0; i2 < this.len; ++i2) {
            if (i2 != this.len - 1 && this.labelInfo[this.result[i2]].charAt(0) != '2' && this.labelInfo[this.result[i2]].charAt(0) != '3') continue;
            ts.add(new TaggedWord());
            for (int j = offset; j < i2 + 1; ++j) {
                ts.get((int)(ts.size() - 1)).word = ts.get((int)(ts.size() - 1)).word + this.sequence.charAt(j);
            }
            offset = i2 + 1;
            ts.get((int)(ts.size() - 1)).tag = this.labelInfo[this.result[i2]].substring(1);
        }
        return true;
    }
}

