/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.cb;

import java.util.Vector;
import org.thunlp.thulac.cb.CBModel;
import org.thunlp.thulac.data.Dat;

public class CBNGramFeature {
    private static final int SENTENCE_BOUNDARY = 35;
    private int separator = 32;
    private int maxLength;
    private int[] uniBases;
    private int[] biBases;
    private int[] values;
    private int datSize;
    private int[] dat;
    private CBModel model;

    public CBNGramFeature(Dat myDat, CBModel model, int[] values) {
        this.datSize = myDat.datSize;
        this.dat = myDat.dat;
        this.model = model;
        this.maxLength = 20000;
        this.uniBases = new int[this.maxLength + 2];
        this.biBases = new int[this.maxLength + 4];
        this.values = values;
    }

    private void addValues(int valueOffset, int base, int del) {
        int ind = this.dat[base << 1] + del;
        if (ind >= this.datSize || this.dat[(ind << 1) + 1] != base) {
            return;
        }
        int offset = this.dat[ind << 1];
        int weightOffset = offset * this.model.l_size;
        if (this.model.l_size == 4) {
            int n = valueOffset;
            this.values[n] = this.values[n] + this.model.fl_weights[weightOffset];
            int n2 = valueOffset + 1;
            this.values[n2] = this.values[n2] + this.model.fl_weights[weightOffset + 1];
            int n3 = valueOffset + 2;
            this.values[n3] = this.values[n3] + this.model.fl_weights[weightOffset + 2];
            int n4 = valueOffset + 3;
            this.values[n4] = this.values[n4] + this.model.fl_weights[weightOffset + 3];
        } else {
            for (int i = 0; i < this.model.l_size; ++i) {
                int n = valueOffset + i;
                this.values[n] = this.values[n] + this.model.fl_weights[weightOffset + i];
            }
        }
    }

    private Vector<Integer> findBases(int datSize, int ch1, int ch2) {
        Vector<Integer> result = new Vector<Integer>();
        if (ch1 > 32 && ch1 < 128) {
            ch1 += 65248;
        }
        if (ch2 > 32 && ch2 < 128) {
            ch2 += 65248;
        }
        if (ch1 >= datSize || this.dat[(ch1 << 1) + 1] != 0) {
            int uniBase = -1;
            int biBase = -1;
            result.clear();
            result.add(uniBase);
            result.add(biBase);
            return result;
        }
        int uniBase = this.dat[ch1 << 1] + this.separator;
        int ind = this.dat[ch1 << 1] + ch2;
        if (ind >= datSize || this.dat[(ind << 1) + 1] != ch1) {
            int biBase = -1;
            result.clear();
            result.add(uniBase);
            result.add(biBase);
            return result;
        }
        int biBase = this.dat[ind << 1] + this.separator;
        result.clear();
        result.add(uniBase);
        result.add(biBase);
        return result;
    }

    public int putValues(String sequence, int len) {
        if (len >= this.maxLength) {
            System.err.println("Length larger than maxLength.");
            return 1;
        }
        Vector<Integer> result = this.findBases(this.datSize, 35, 35);
        this.uniBases[0] = result.get(0);
        this.biBases[0] = result.get(1);
        result = this.findBases(this.datSize, 35, sequence.charAt(0));
        this.uniBases[0] = result.get(0);
        this.biBases[1] = result.get(1);
        int i = 0;
        while (i + 1 < len) {
            result = this.findBases(this.datSize, sequence.charAt(i), sequence.charAt(i + 1));
            this.uniBases[i + 1] = result.get(0);
            this.biBases[i + 2] = result.get(1);
            ++i;
        }
        result = this.findBases(this.datSize, sequence.charAt(len - 1), 35);
        this.uniBases[len] = result.get(0);
        this.biBases[len + 1] = result.get(1);
        result = this.findBases(this.datSize, 35, 35);
        this.uniBases[len + 1] = result.get(0);
        this.biBases[len + 2] = result.get(1);
        for (int i2 = 0; i2 < len; ++i2) {
            int valueOffset = i2 * this.model.l_size;
            int base = this.uniBases[i2 + 1];
            if (base != -1) {
                this.addValues(valueOffset, base, 49);
            }
            if ((base = this.uniBases[i2]) != -1) {
                this.addValues(valueOffset, base, 50);
            }
            if ((base = this.uniBases[i2 + 2]) != -1) {
                this.addValues(valueOffset, base, 51);
            }
            if ((base = this.biBases[i2 + 1]) != -1) {
                this.addValues(valueOffset, base, 49);
            }
            if ((base = this.biBases[i2 + 2]) != -1) {
                this.addValues(valueOffset, base, 50);
            }
            if ((base = this.biBases[i2]) != -1) {
                this.addValues(valueOffset, base, 51);
            }
            if ((base = this.biBases[i2 + 3]) == -1) continue;
            this.addValues(valueOffset, base, 52);
        }
        return 0;
    }
}

