/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.ueditor.upload;

import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.UUIDUtils;
import com.bxm.newidea.component.ueditor.define.BaseState;
import com.bxm.newidea.component.ueditor.define.State;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.MultimediaInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class BinaryUploader {
    private static Logger logger = LoggerFactory.getLogger(BinaryUploader.class);

    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            BaseState storageState = null;
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (multipartResolver.isMultipart(request)) {
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
                Iterator it = multiRequest.getFileNames();
                while (it.hasNext()) {
                    String fileName;
                    MultipartFile file = multiRequest.getFile((String)it.next());
                    if (file == null || (fileName = file.getOriginalFilename()).trim() == "") continue;
                    File newFile = new File(fileName);
                    FileOutputStream outStream = new FileOutputStream(newFile);
                    outStream.write(file.getBytes());
                    outStream.close();
                    file.transferTo(newFile);
                    try {
                        storageState = new BaseState(Boolean.TRUE);
                        storageState.putInfo("state", "SUCCESS");
                        String pathWithoutSuffix = UUIDUtils.nextID();
                        String path = pathWithoutSuffix + "." + FileUtils.getFileExtension((File)newFile);
                        String url = BinaryUploader.getService().upload(newFile, path);
                        logger.debug("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0curl\uff1a{}", (Object)url);
                        if (BinaryUploader.isImage(newFile).booleanValue()) {
                            url = url + "?x-oss-process=style/mcompress";
                        }
                        if (BinaryUploader.isVideo(newFile).booleanValue()) {
                            BinaryUploader.cacheVideoInfo(url, newFile, pathWithoutSuffix);
                        }
                        storageState.putInfo("url", url);
                        storageState.putInfo("title", fileName);
                        storageState.putInfo("original", fileName);
                        newFile.delete();
                    }
                    catch (Exception e) {
                        storageState.putInfo("state", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!");
                        storageState.putInfo("url", "");
                        storageState.putInfo("title", "");
                        storageState.putInfo("original", "");
                        logger.error(e.getMessage());
                    }
                }
            }
            return storageState;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }

    private static AliyunOSSService getService() {
        return (AliyunOSSService)SpringContextHolder.getBean((String)"aliyunOssService");
    }

    private static Boolean isImage(File file) {
        String suffix = FileUtils.getFileExtension((File)file);
        return FileTypeEnum.JPE.getExtName().equals(suffix) || FileTypeEnum.JPEG.getExtName().equals(suffix) || FileTypeEnum.PNG.getExtName().equals(suffix);
    }

    private static Boolean isVideo(File file) {
        String suffix = FileUtils.getFileExtension((File)file);
        return FileTypeEnum.AVI.getExtName().equals(suffix) || FileTypeEnum.FLV.getExtName().equals(suffix) || FileTypeEnum.MP4.getExtName().equals(suffix);
    }

    private static void cacheVideoInfo(String videoUrl, File file, String videoBaseName) throws EncoderException, IOException {
        logger.debug("\u89c6\u9891\u4e0a\u4f20\u5b8c\u6bd5\u5f00\u59cb\u5904\u7406\uff0c\u53c2\u6570\uff1a{}", (Object)videoUrl);
        Encoder encoder = new Encoder();
        MultimediaInfo m = encoder.getInfo(file);
        long ls = m.getDuration();
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        BigDecimal fileSize = new BigDecimal(fc.size());
        logger.debug("\u89c6\u9891\u5904\u7406\u83b7\u5f97\u5927\u5c0f\uff1a{}\uff0c\u65f6\u957f\uff1a{}", (Object)fileSize, (Object)ls);
        String imgUrl = BinaryUploader.getImageFromCover(videoUrl, videoBaseName);
        logger.debug("\u89c6\u9891\u5904\u7406\u83b7\u5f97\u5c01\u9762\uff1a{}", (Object)imgUrl);
        HashMap<String, Object> videoCacheMap = new HashMap<String, Object>();
        videoCacheMap.put("duration", ls);
        videoCacheMap.put("size", fileSize);
        videoCacheMap.put("imgUrl", imgUrl);
        DefaultKeyGenerator videoCacheKey = DefaultKeyGenerator.build((String)"cache", (String)"static", (String)"videoinfo");
        logger.debug("\u5c06\u89c6\u9891\u4fe1\u606f\u5b58\u5165redis\u4e2d\uff0credisKey:{},subKey:{},info:{}", new Object[]{videoCacheKey, videoBaseName, videoCacheMap});
        RedisHashMapAdapter redisHashMapAdapter = (RedisHashMapAdapter)SpringContextHolder.getBean(RedisHashMapAdapter.class);
        redisHashMapAdapter.put((KeyGenerator)videoCacheKey, videoBaseName, videoCacheMap);
        redisHashMapAdapter.expire((KeyGenerator)videoCacheKey, 86400L);
    }

    private static String getImageFromCover(String videoUrl, String videoBaseName) {
        long begin = System.currentTimeMillis();
        String coverUlr = videoUrl + "?x-oss-process=video/snapshot,t_1000,m_fast,ar_auto";
        InputStream inputStream = BinaryUploader.getInputStreamByUrl(coverUlr);
        logger.debug(" \u6839\u636eurl\u83b7\u5f97\u56fe\u7247\u7684\u8f93\u5165\u6d41\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        String path = videoBaseName + ".jpeg";
        return BinaryUploader.getService().upload(inputStream, path) + "?x-oss-process=style/video";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStreamByUrl(String strUrl) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(strUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(20000);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)output);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(output.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            logger.error(e + "");
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception e) {
                logger.error(e + "");
            }
        }
        return null;
    }
}

