package com.bxm.newidea.component.uuid.impl;

import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.ComponentUUIDConfigurationProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.NumberUtils;

/**
 * 雪花算法实现的序列创建类
 * @author liujia
 * @date 2020/04/23 09:40
 */
@Slf4j
public class SnowflakeSequenceCreater implements SequenceCreater {
    private Sequence sequence;

    /**
     * 初始化序列创建器
     * @param properties 构建参数
     */
    public void init(ComponentUUIDConfigurationProperties properties) {
        Long workerId = properties.getWorkerid();
        Long dataCenterId = properties.getDataCenterId();

        //优先使用环境配置中的值
        String configWorkerId = System.getProperty("uuid.workerid");
        if (null != configWorkerId) {
            log.debug("使用系统配置的[uuid.workerid]:[{}]", configWorkerId);
            workerId = NumberUtils.parseNumber(configWorkerId, Long.class);
        }

        String configDataCenterId = System.getProperty("uuid.dataCenterId");
        if (null != configDataCenterId) {
            log.debug("使用系统配置的[uuid.dataCenterId]:[{}]", configDataCenterId);
            dataCenterId = NumberUtils.parseNumber(configDataCenterId, Long.class);
        }

        //环境配置与spring配置中均未发现参数，则使用随机值
        if (workerId == null) {
            workerId = RandomUtils.nextLong(0, 255);
        }

        if (dataCenterId == null) {
            dataCenterId = RandomUtils.nextLong(0, 31);
        }

        log.info("序列创建参数,workerId:{},dataCenterId:{}", workerId, dataCenterId);

        this.sequence = new Sequence(workerId, dataCenterId);
    }

    @Override
    public Long nextLongId() {
        return this.sequence.nextId();
    }

    @Override
    public String nextStringId() {
        return this.sequence.nextId().toString();
    }
}
