/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid.snowflake;

import com.bxm.newidea.component.uuid.utils.SystemClock;

class Sequence {
    private final long startTime = 1519740777809L;
    private final long workerIdBits = 8L;
    private final long dataCenterIdBits = 5L;
    private final long sequenceBits = 4L;
    private final long maxWorkerId;
    private final long maxDataCenterId;
    private final long workerIdShift;
    private final long dataCenterIdShift;
    private final long timestampLeftShift;
    private final long sequenceMask;
    private long workerId;
    private long dataCenterId;
    private long sequence;
    private long lastTimestamp;
    private boolean isClock;

    public Sequence(long workerId, long dataCenterId) {
        this.getClass();
        this.maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << 8;
        this.getClass();
        this.maxDataCenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << 5;
        this.workerIdShift = this.sequenceBits;
        this.dataCenterIdShift = this.sequenceBits + this.workerIdBits;
        this.timestampLeftShift = this.sequenceBits + this.workerIdBits + this.dataCenterIdBits;
        this.getClass();
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << 4;
        this.sequence = 0L;
        this.lastTimestamp = -1L;
        this.isClock = true;
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        if (dataCenterId > this.maxDataCenterId || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenter Id can't be greater than %d or less than 0", this.maxDataCenterId));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public void setClock(boolean clock) {
        this.isClock = clock;
    }

    public synchronized Long nextId() {
        long timestamp;
        block8: {
            timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.startTime << (int)this.timestampLeftShift | this.dataCenterId << (int)this.dataCenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        if (this.isClock) {
            return SystemClock.now();
        }
        return System.currentTimeMillis();
    }
}

