/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid.snowflake;

import com.bxm.newidea.component.strategy.ReturnedStrategyExecutor;
import com.bxm.newidea.component.tools.NetworkInterfaceManager;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.ComponentUUIDConfigurationProperties;
import com.bxm.newidea.component.uuid.config.SequenceConfigHolder;
import com.bxm.newidea.component.uuid.snowflake.Sequence;
import com.bxm.newidea.component.uuid.strategy.RandomAcquireConfigStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.util.NumberUtils;

public class SnowflakeSequenceCrater
implements SequenceCreater,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeSequenceCrater.class);
    private Sequence sequence;
    private ComponentUUIDConfigurationProperties properties;
    private ReturnedStrategyExecutor returnedStrategyExecutor;

    public SnowflakeSequenceCrater(ComponentUUIDConfigurationProperties properties, ReturnedStrategyExecutor returnedStrategyExecutor) {
        this.properties = properties;
        this.returnedStrategyExecutor = returnedStrategyExecutor;
    }

    @Override
    public Long nextLongId() {
        return this.sequence.nextId();
    }

    @Override
    public String nextStringId() {
        return this.sequence.nextId().toString();
    }

    public void run(ApplicationArguments args) {
        String configDataCenterId;
        String configWorkerId;
        Long workerId = null;
        Long dataCenterId = null;
        if (null != this.properties.getDataCenterId()) {
            dataCenterId = this.properties.getDataCenterId();
        }
        if (null != this.properties.getWorkId()) {
            workerId = this.properties.getWorkId();
        }
        if (null != (configWorkerId = System.getProperty("component.uuid.workerid"))) {
            log.debug("\u4f7f\u7528\u7cfb\u7edf\u914d\u7f6e\u7684[{}]:[{}]", (Object)"component.uuid.workerid", (Object)configWorkerId);
            workerId = (Long)NumberUtils.parseNumber((String)configWorkerId, Long.class);
        }
        if (null != (configDataCenterId = System.getProperty("component.uuid.dataCenterId"))) {
            log.debug("\u4f7f\u7528\u7cfb\u7edf\u914d\u7f6e\u7684[{}]:[{}]", (Object)"component.uuid.dataCenterId", (Object)configDataCenterId);
            dataCenterId = (Long)NumberUtils.parseNumber((String)configDataCenterId, Long.class);
        }
        if (null == dataCenterId || null == workerId) {
            SequenceConfigHolder acquire = null;
            if (this.properties.isFastMode()) {
                acquire = new RandomAcquireConfigStrategy().execute(null);
            } else if (null != this.returnedStrategyExecutor) {
                acquire = (SequenceConfigHolder)this.returnedStrategyExecutor.execute("COMPONENT_UUID_ACQUIRE_CONFIG_GROUP", this.properties.getAcquireConfigStrategy(), null);
            }
            if (null == acquire) {
                acquire = new RandomAcquireConfigStrategy().execute(null);
            }
            if (null == workerId) {
                workerId = acquire.getWorkerId();
            }
            if (null == dataCenterId) {
                dataCenterId = acquire.getDataCenterId();
            }
        }
        log.info("ID\u751f\u6210\u914d\u7f6e\uff0cserverName:[{}],ip:[{}],port:[{}],dataCenterId:[{}],workerId:[{}]", new Object[]{this.properties.getLeafName(), NetworkInterfaceManager.INSTANCE.getLocalHostAddress(), this.properties.getLeafPort(), dataCenterId, workerId});
        if (workerId == null) {
            workerId = 0L;
        }
        if (dataCenterId == null) {
            dataCenterId = 0L;
        }
        this.sequence = new Sequence(workerId, dataCenterId);
        this.sequence.setClock(true);
    }
}

