package com.bxm.newidea.component.uuid.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.bxm.newidea.component.uuid.constant.SequenceConstant.RANDOM_STRATEGY_NAME;

/**
 * uuid模块的相关配置
 *
 * @author liujia
 * @date 2020/04/23 09:35
 */
@Data
@ConfigurationProperties(prefix = "component.uuid")
public class ComponentUUIDConfigurationProperties {

    /**
     * 数据中心ID，数值范围0-31
     */
    private Long dataCenterId = 0L;

    /**
     * 获取序列号配置的策略，支持：
     * random：随机获取
     * zk：通过zookeeper获取
     */
    private String acquireConfigStrategy = RANDOM_STRATEGY_NAME;

    /**
     * 如果使用zookeeper来获取workerId，则需要提供连接地址
     */
    private String zookeeperAddress;

    /**
     * 节点名称，默认为项目名称
     * 相同节点名称下的实例自增
     */
    @Value("${spring.application.name:uuid_leaf}")
    private String leafName;

    /**
     * 当前应用端口号，用于配合IP区分相同应用下的不同部署实例
     */
    @Value("${server.port:8080}")
    private Integer leafPort;

    /**
     * 快速启动模式，研发或测试的时候不需要连接zookeeper
     */
    private boolean fastMode = false;
}
