package com.bxm.newidea.component.uuid.strategy;

import com.bxm.newidea.component.annotations.StrategyBean;
import com.bxm.newidea.component.strategy.IReturnedStrategy;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.uuid.config.SequenceConfigHolder;
import lombok.extern.slf4j.Slf4j;

import static com.bxm.newidea.component.uuid.constant.SequenceConstant.ACQUIRE_CONFIG_GROUP;
import static com.bxm.newidea.component.uuid.constant.SequenceConstant.RANDOM_STRATEGY_NAME;

/**
 * 随机设置dataCenterId和workerId
 *
 * @author liujia
 * @date 6/4/21 6:01 PM
 **/
@Slf4j
@StrategyBean(group = ACQUIRE_CONFIG_GROUP)
public class RandomAcquireConfigStrategy implements IReturnedStrategy<SequenceConfigHolder, Void> {

    @Override
    public SequenceConfigHolder execute(Void param) {
        SequenceConfigHolder holder = SequenceConfigHolder.builder()
                .dataCenterId(RandomUtils.nextLong(0, 31))
                .workerId(RandomUtils.nextLong(0, 255))
                .build();

        log.info("ID采用随机生成策略，dataCenterId:{},workerId:{}", holder.getDataCenterId(), holder.getWorkerId());

        return holder;
    }

    @Override
    public String name() {
        return RANDOM_STRATEGY_NAME;
    }
}
