package com.bxm.newidea.component.uuid;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 序列创建工具，用于创建有序的序列（根据时间大致有序）
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_SINGLETON)
public class SequenceCreater {

    @Value("${component.uuid.workerid:0}")
    private long workerId;

    @Value("${component.uuid.dataCenterId:2}")
    private long dataCenterId;

    private Sequence sequence;

    @PostConstruct
    private void init(){
        sequence = new Sequence(workerId,dataCenterId);
    }

    public Long nextLongId(){
        return sequence.nextId();
    }

    public String nextStringId(){
        return sequence.nextId().toString();
    }
}
