package com.bxm.newidea.component.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 常用校验规则
 * @author liujia 2018/7/30 14:31
 */
public class Validater {

    private Validater() {
    }

    /**
     * 严格模式的手机号码校验
     */
    private final static String STRICT_PHONE_NUMBER = "^[1](([3|5|8][\\d])|([4][5,6,7,8,9])|([6][5,6])|([7][0,1,3,4,5,6,7,8])|([9][8,9]))[\\d]{8}$";

    /**
     * 宽松模式的手机号码校验，防止运营商出现莫名其妙的号码段
     */
    private final static String PHONE_NUMBER = "^1\\d{10}$";

    private static Pattern strict_pattern = Pattern.compile(STRICT_PHONE_NUMBER);

    private static Pattern pattern = Pattern.compile(PHONE_NUMBER);

    /**
     * 使用宽松模式匹配手机号码，前缀为1，长度11即可
     * @param phone 手机号码
     * @return true表示验证通过
     */
    public static boolean checkPhone(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return false;
        }
        Matcher matcher = pattern.matcher(phone);
        return matcher.matches();
    }

    /**
     * 手机号校验
     * 2019年1月16日已知
     * 中国电信号段
     * 133,149,153,173,174,177,180,181,189,199
     * 中国联通号段
     * 130,131,132,145,146,155,156,166,175,176,185,186
     * 中国移动号段
     * 134(0-8),135,136,137,138,139,147,148,150,151,152,157,158,159,165,178,182,183,184,187,188,198
     * 上网卡专属号段（用于上网和收发短信，不拨打电话）
     * 如中国联通的是145
     * 虚拟运营商
     * 电信：1700,1701,1702
     * 移动：1703,1705,1706
     * 联通：1704,1707,1708,1709,171
     * 卫星通信： 1349  未知号段：141、142、143、144、154
     * @param phone 手机号码
     * @return true表示验证通过
     */
    public static boolean checkPhoneWithStrict(String phone) {
        if (StringUtils.isEmpty(phone)) {
            return false;
        }
        Matcher matcher = strict_pattern.matcher(phone);
        return matcher.matches();
    }
}
