/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.config;

import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.SwaggerConfig;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

public class ExposeSwaggerApiConfiguration {
    private List<SwaggerConfig> apiModuleArray = Lists.newArrayList();
    private List<SwaggerConfig> manageApiModuleArray = Lists.newArrayList();
    private List<SwaggerConfig> thirdApiModuleArray = Lists.newArrayList();
    private Set<String> allModuleSet = Sets.newHashSet();
    @Value(value="${spring.application.name}")
    private String applicationName;

    protected void addApiModule(SwaggerConfig apiModule) {
        this.checkRepeat(apiModule.getGroupName());
        this.apiModuleArray.add(apiModule);
    }

    protected void addManageApiModule(SwaggerConfig manageApiModule) {
        this.checkRepeat(manageApiModule.getGroupName());
        this.manageApiModuleArray.add(manageApiModule);
    }

    protected void addThirdApiModule(SwaggerConfig thirdApiModule) {
        this.checkRepeat(thirdApiModule.getGroupName());
        this.thirdApiModuleArray.add(thirdApiModule);
    }

    private void checkRepeat(String apiModule) {
        if (!this.allModuleSet.add(apiModule)) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u5b9a\u4e49\u76f8\u540c\u7684Module\u540d\u79f0\uff0c\u8bf7\u91cd\u547d\u540d");
        }
    }

    protected DocketBuilder exposeApi() {
        return new DocketBuilder().api();
    }

    protected DocketBuilder exposeManageApi() {
        return new DocketBuilder().manageApi();
    }

    protected DocketBuilder exposeThirdApi() {
        return new DocketBuilder().thirdApi();
    }

    public class DocketBuilder {
        private String moduleName;
        private boolean api;
        private boolean manageApi;
        private boolean thirdApi;
        private String version;
        private String description;
        private String scanPackage;
        private String author = "\u533f\u540d";
        private String authorEmail = "";
        private int order = 0;

        private DocketBuilder() {
        }

        public DocketBuilder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public DocketBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DocketBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocketBuilder scanPackage(String scanPackage) {
            this.scanPackage = scanPackage;
            return this;
        }

        public DocketBuilder author(String author) {
            this.author = author;
            return this;
        }

        public DocketBuilder authorEmail(String authorEmail) {
            this.authorEmail = authorEmail;
            return this;
        }

        public DocketBuilder order(int order) {
            this.order = order;
            return this;
        }

        DocketBuilder api() {
            this.api = true;
            return this;
        }

        DocketBuilder thirdApi() {
            this.thirdApi = true;
            return this;
        }

        DocketBuilder manageApi() {
            this.manageApi = true;
            return this;
        }

        public Docket build() {
            if (StringUtils.isBlank((CharSequence)this.moduleName)) {
                throw new IllegalArgumentException("moduleName\u5fc5\u987b\u914d\u7f6e");
            }
            if (StringUtils.isBlank((CharSequence)this.scanPackage)) {
                throw new IllegalArgumentException("scanPackage\u5fc5\u987b\u914d\u7f6e");
            }
            SwaggerConfig swaggerConfig = new SwaggerConfig();
            swaggerConfig.setGroupName(this.moduleName);
            swaggerConfig.setOrder(this.order);
            swaggerConfig.setVersion(this.version);
            swaggerConfig.setServiceName(ExposeSwaggerApiConfiguration.this.applicationName);
            if (this.api) {
                ExposeSwaggerApiConfiguration.this.addApiModule(swaggerConfig);
            }
            if (this.manageApi) {
                ExposeSwaggerApiConfiguration.this.addManageApiModule(swaggerConfig);
            }
            if (this.thirdApi) {
                ExposeSwaggerApiConfiguration.this.addThirdApiModule(swaggerConfig);
            }
            ApiInfo apiInfo = new ApiInfoBuilder().title(this.moduleName).description(this.description).contact(new Contact(this.author, "", this.authorEmail)).version(this.version).build();
            Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).groupName(this.moduleName).select().apis(RequestHandlerSelectors.basePackage((String)this.scanPackage)).paths(PathSelectors.any()).build();
            docket.useDefaultResponseMessages(false);
            return docket;
        }
    }

    @RestController
    public class ExposeSwaggerApiController {
        @GetMapping(value={"/expose/swagger/fetch"})
        public List<SwaggerConfig> apiModule(String type) {
            switch (type) {
                case "manage": {
                    return ExposeSwaggerApiConfiguration.this.manageApiModuleArray;
                }
                case "3rd": {
                    return ExposeSwaggerApiConfiguration.this.thirdApiModuleArray;
                }
            }
            return ExposeSwaggerApiConfiguration.this.apiModuleArray;
        }
    }
}

