/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.config;

import com.bxm.newidea.component.config.ComponentWebConfigurationProperties;
import com.bxm.newidea.component.log.LogContextFilter;
import com.bxm.newidea.component.mvc.ApiVersionRequestMapping;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={ComponentWebConfigurationProperties.class})
public class ComponentWebAutoConfiguration
implements WebMvcRegistrations,
WebMvcConfigurer {
    private ComponentWebConfigurationProperties properties;
    @Resource
    private HttpMessageConverters httpMessageConverters;

    public ComponentWebAutoConfiguration(ComponentWebConfigurationProperties properties) {
        this.properties = properties;
    }

    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new ApiVersionRequestMapping();
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.addAll(this.httpMessageConverters.getConverters());
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter() {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(new MediaType(MediaType.TEXT_PLAIN, Charset.forName("UTF-8")));
        supportedMediaTypes.add(new MediaType(MediaType.APPLICATION_JSON, Charset.forName("UTF-8")));
        jsonConverter.setSupportedMediaTypes(supportedMediaTypes);
        ObjectMapper objectMapper = jsonConverter.getObjectMapper();
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        return jsonConverter;
    }

    @Bean
    @ConditionalOnProperty(prefix="component.web", value={"enableLogFilter"}, matchIfMissing=true)
    public LogContextFilter logContextFilter() {
        return new LogContextFilter(this.properties);
    }

    @Bean
    @Primary
    public Validator validator() {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(this.properties.isFastValid()).buildValidatorFactory();
        return validatorFactory.getValidator();
    }
}

