package com.bxm.newidea.component.wechat.listener;

import com.bxm.newidea.component.wechat.config.WechatMpContext;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;

/**
 * 配置文件变更监听
 *
 * @author liujia
 * @date 2020/5/29 17:10
 **/
public class PropertiesChangeListener {

    private final WechatMpContext context;

    public PropertiesChangeListener(WechatMpContext context) {
        this.context = context;
    }

    @ApolloConfigChangeListener(value = "thirdparty", interestedKeyPrefixes = "thirdparty.wechat.mp")
    public void change() {
        //配置信息发生变更时，重新生成对应的服务类
        context.refresh();
    }
}
