package com.bxm.newidea.component.wechat.service;

import com.bxm.newidea.component.wechat.param.WechatOnAuth2UrlParam;
import com.bxm.newidea.component.wechat.param.WxMpJsSignatureParam;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.mp.bean.result.WxMpUser;

/**
 * 微信公众号提供的对外服务能力，屏蔽业务实现细节，只关注公众号本身的逻辑
 * 降低调用端对公众号具体操作的理解成本
 *
 * @author liujia
 * @date 2020/5/29 15:18
 **/
public interface WechatMpService {

    /**
     * 获取授权地址
     * 通过将原始的URL地址进行处理，获取可以在微信中直接弹出授权弹窗的地址
     *
     * @return 授权地址，访问将拉起用户授权确认弹窗,如果未匹配，则返回null
     */
    String acquireAuthUrl(WechatOnAuth2UrlParam param);

    /**
     * 获取js签名相关的参数
     * 前端如果需要使用到微信提供的js-sdk相关能力（分享、支付、获取用户信息等）需要调用此服务
     *
     * @return 微信签名信息，前端用此信息申请js-sdk的调用，如果未找到匹配的公众号，将返回null
     */
    WxJsapiSignature acquireJsSignature(WxMpJsSignatureParam param);

    /**
     * 通过授权地址弹出微信确认授权窗口
     * 用户确认授权后将跳转到授权地址的回调地址，前端拿到authCode与后端交换微信用户信息
     *
     * @param scene    业务场景名称（用于匹配查找可用的公众号）
     * @param authCode 前端获取到的授权码
     * @return 微信用户信息，如果为null表示获取失败，具体错误详见日志
     */
    WxMpUser exchangeWxMapUser(String scene, String authCode);
}
