/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.wechat.extend;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.wechat.constant.RedisKeyConstant;
import com.bxm.newidea.component.wechat.extend.CustomApacheHttpClientBuilder;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.enums.TicketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpInRedisConfigStorage
extends WxMpInMemoryConfigStorage {
    private static final Logger log = LoggerFactory.getLogger(WxMpInRedisConfigStorage.class);
    private static final String ACCESS_TOKEN_KEY = "wechat_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_jsapi_ticket_";
    private static final String CARDAPI_TICKET_KEY = "wechat_cardapi_ticket_";
    private RedisStringAdapter redisStringAdapter;
    private String accessTokenKey;
    private String jsapiTicketKey;
    private String cardapiTicketKey;
    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;
    private KeyGenerator accessKeyCacheKey;

    public WxMpInRedisConfigStorage(RedisStringAdapter redisStringAdapter, CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.redisStringAdapter = redisStringAdapter;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
        this.setApacheHttpClientBuilder(customApacheHttpClientBuilder);
    }

    public void setAppId(String appId) {
        super.setAppId(appId);
        this.accessKeyCacheKey = RedisKeyConstant.WEIXIN_MP_ACCESS_KEY.copy().appendKey((Object)appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(appId);
        this.cardapiTicketKey = CARDAPI_TICKET_KEY.concat(appId);
    }

    private KeyGenerator getWxMpKey(String key) {
        return this.accessKeyCacheKey.appendKey((Object)key);
    }

    public String getAccessToken() {
        return this.redisStringAdapter.getString(this.getWxMpKey(this.accessTokenKey));
    }

    public void expireAccessToken() {
        log.info("{}\u4e3b\u52a8\u6267\u884caccessToken\u8fc7\u671f", (Object)this.appId);
        this.redisStringAdapter.remove(this.getWxMpKey(this.accessTokenKey));
        super.expireAccessToken();
    }

    public boolean isAccessTokenExpired() {
        return this.redisStringAdapter.hasKey(this.getWxMpKey(this.accessTokenKey)) == false;
    }

    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisStringAdapter.set(this.getWxMpKey(this.accessTokenKey), (Object)accessToken, (long)expiresInSeconds - 200L);
    }

    public String getTicket(TicketType ticketType) {
        String jsapiTicket = this.redisStringAdapter.getString(this.getWxMpKey(this.jsapiTicketKey));
        log.info("[\u5fae\u4fe1{}:\u7684\u7968\u636e:{}]", (Object)this.appId, (Object)jsapiTicket);
        return jsapiTicket;
    }

    public boolean isTicketExpired(TicketType ticketType) {
        KeyGenerator wxMpKey = this.getWxMpKey(this.jsapiTicketKey);
        log.info("[\u5fae\u4fe1{}:js\u7684key:{}\u662f\u5426\u8fc7\u671f]", (Object)this.appId, (Object)wxMpKey);
        return this.redisStringAdapter.hasKey(wxMpKey) == false;
    }

    public synchronized void updateTicket(TicketType type, String ticket, int expiresInSeconds) {
        KeyGenerator wxMpKey = this.getWxMpKey(this.jsapiTicketKey);
        log.info("[\u5fae\u4fe1{}:js\u7684key:{},\u7968\u636e\uff1a{}, \u8fc7\u671f\u65f6\u95f4: {}]", new Object[]{this.appId, wxMpKey, ticket, (long)expiresInSeconds - 200L});
        this.redisStringAdapter.set(wxMpKey, (Object)ticket, (long)expiresInSeconds - 200L);
    }
}

