package com.bxm.newidea.component.wechat.config;

import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.wechat.extend.CustomApacheHttpClientBuilder;
import com.bxm.newidea.component.wechat.listener.PropertiesChangeListener;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 微信相关内容的自动装配
 *
 * @author liujia
 * @date 2020/5/29 13:55
 **/
@Configuration
@EnableConfigurationProperties(WechatMpProperties.class)
public class WechatAutoConfiguration {

    @Bean
    public WechatMpContext factory(WechatMpProperties properties,
                                   RedisStringAdapter redisStringAdapter,
                                   CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        return new WechatMpContext(properties, redisStringAdapter, customApacheHttpClientBuilder);
    }

    @Bean
    public CustomApacheHttpClientBuilder customApacheHttpClientBuilder(CloseableHttpClient client) {
        return new CustomApacheHttpClientBuilder(client);
    }

    @Bean
    public PropertiesChangeListener propertiesChangeListener(WechatMpContext context) {
        return new PropertiesChangeListener(context);
    }
}
