/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.wechat.config;

import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.wechat.config.WechatMpContext;
import com.bxm.newidea.component.wechat.config.WechatMpProperties;
import com.bxm.newidea.component.wechat.extend.CustomApacheHttpClientBuilder;
import com.bxm.newidea.component.wechat.listener.PropertiesChangeListener;
import com.bxm.newidea.component.wechat.service.WxMpConfigStorageBuilder;
import com.bxm.newidea.component.wechat.service.impl.WxMpMemoryConfigStorageBuilder;
import com.bxm.newidea.component.wechat.service.impl.WxMpRedisConfigStorageBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableConfigurationProperties(value={WechatMpProperties.class})
public class WechatAutoConfiguration {
    @Bean
    public WechatMpContext factory(WechatMpProperties properties, WxMpConfigStorageBuilder builder) {
        return new WechatMpContext(properties, builder);
    }

    @Bean
    public CustomApacheHttpClientBuilder customApacheHttpClientBuilder(CloseableHttpClient client) {
        return new CustomApacheHttpClientBuilder(client);
    }

    @Bean
    public PropertiesChangeListener propertiesChangeListener(WechatMpContext context) {
        return new PropertiesChangeListener(context);
    }

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    public WxMpRedisConfigStorageBuilder wxMpRedisConfigStorageBuilder(RedisStringAdapter redisStringAdapter, CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        return new WxMpRedisConfigStorageBuilder(redisStringAdapter, customApacheHttpClientBuilder);
    }

    @Bean
    @ConditionalOnMissingBean(value={WxMpConfigStorageBuilder.class})
    public WxMpMemoryConfigStorageBuilder wxMpMemoryConfigStorageBuilder() {
        return new WxMpMemoryConfigStorageBuilder();
    }
}

