/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.wechat.config;

import com.bxm.newidea.component.wechat.config.WechatMpAccount;
import com.bxm.newidea.component.wechat.config.WechatMpProperties;
import com.bxm.newidea.component.wechat.service.WxMpConfigStorageBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatMpContext {
    private static final Logger log = LoggerFactory.getLogger(WechatMpContext.class);
    private final WechatMpProperties wechatMPProperties;
    private final WxMpConfigStorageBuilder wxMpConfigStorageBuilder;
    private WxMpService defaultWxMpService;
    private Map<String, WxMpService> wxMpServiceMap;
    private Map<String, WechatMpAccount> accountMap;

    public WechatMpContext(WechatMpProperties wechatMpProperties, WxMpConfigStorageBuilder wxMpConfigStorageBuilder) {
        this.wechatMPProperties = wechatMpProperties;
        this.wxMpConfigStorageBuilder = wxMpConfigStorageBuilder;
        this.refresh();
    }

    public WxMpService obtain(String scene) {
        log.debug("\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u670d\u52a1\uff1a{}", (Object)scene);
        WxMpService matchWxMapService = null;
        if (StringUtils.isBlank((String)scene)) {
            if (null != this.defaultWxMpService) {
                log.debug("\u573a\u666f\u503c\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684\u5fae\u4fe1\u516c\u4f17\u53f7\uff1a{}", (Object)this.defaultWxMpService.getWxMpConfigStorage().getAppId());
                matchWxMapService = this.defaultWxMpService;
            }
        } else {
            matchWxMapService = this.wxMpServiceMap.get(scene);
            if (null == matchWxMapService) {
                log.warn("\u573a\u666f[{}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\uff0c\u8bf7\u786e\u5b9a\u573a\u666f\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\u662f\u5904\u4e8e\u542f\u7528\u72b6\u6001\uff0c\u662f\u5426\u7ed9\u573a\u666f\u6307\u5b9a\u4e86\u516c\u4f17\u53f7", (Object)scene);
                matchWxMapService = this.defaultWxMpService;
            }
        }
        if (matchWxMapService == null) {
            log.error("\u573a\u666f[{}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4e86\u573a\u666f\u548c\u5fae\u4fe1\u7684\u5173\u8054\u5173\u7cfb\u3001\u662f\u5426\u914d\u7f6e\u4e86\u522b\u540d\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\uff0c\u662f\u5426\u914d\u7f6e\u4e86\u9ed8\u8ba4\u7684\u516c\u4f17\u53f7", (Object)scene);
        } else {
            log.debug("\u6839\u636e[{}]\u83b7\u53d6\u7684\u5fae\u4fe1\u516c\u4f17\u53f7\u5b9e\u4f8b\uff1a{}", (Object)scene, (Object)matchWxMapService.getWxMpConfigStorage().getAppId());
        }
        return matchWxMapService;
    }

    public WechatMpAccount obtainAccount(WxMpService service) {
        WechatMpAccount wechatMpAccount = this.accountMap.get(service.getWxMpConfigStorage().getAppId());
        if (wechatMpAccount == null) {
            wechatMpAccount = new WechatMpAccount();
            wechatMpAccount.setAuthDomainUrls(Lists.newArrayList());
            wechatMpAccount.setJsSignatureDomainUrls(Lists.newArrayList());
        }
        return wechatMpAccount;
    }

    public void refresh() {
        HashMap swapMap = Maps.newHashMap();
        HashMap swapAccountMap = Maps.newHashMap();
        this.wechatMPProperties.getRelation().forEach((scnen, alias) -> {
            boolean hit = false;
            for (WechatMpAccount account : this.wechatMPProperties.getAccounts()) {
                if (!this.checkAccount(account)) {
                    return;
                }
                WxMpService wxMpService = this.build(account);
                if (com.bxm.newidea.component.tools.StringUtils.equals((CharSequence)alias, (CharSequence)account.getAlias())) {
                    swapMap.put(scnen, wxMpService);
                    hit = true;
                }
                if (com.bxm.newidea.component.tools.StringUtils.equals((CharSequence)this.wechatMPProperties.getMasterMpAlias(), (CharSequence)account.getAlias())) {
                    this.defaultWxMpService = wxMpService;
                }
                swapAccountMap.put(account.getAppId(), account);
            }
            if (!hit) {
                log.error("\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff0c\u573a\u666f[{}]\u5bf9\u5e94\u7684\u516c\u4f17\u53f7[{}]\u4e0d\u5b58\u5728", scnen, alias);
            }
        });
        this.accountMap = swapAccountMap;
        this.wxMpServiceMap = swapMap;
    }

    private boolean checkAccount(WechatMpAccount account) {
        boolean pass = true;
        if (StringUtils.isBlank((String)account.getAppId())) {
            log.error("\u516c\u4f17\u53f7APPID\u5fc5\u987b\u914d\u7f6e,\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)account);
            pass = false;
        }
        if (StringUtils.isBlank((String)account.getAppSecret())) {
            log.error("\u516c\u4f17\u53f7\u5bc6\u94a5\u5fc5\u987b\u914d\u7f6e,\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)account);
            pass = false;
        }
        if (StringUtils.isBlank((String)account.getAlias())) {
            log.error("\u516c\u4f17\u53f7\u522b\u540d\u5fc5\u987b\u914d\u7f6e,\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)account);
            pass = false;
        }
        return pass;
    }

    private WxMpService build(WechatMpAccount account) {
        WxMpServiceImpl service = new WxMpServiceImpl();
        service.setWxMpConfigStorage((WxMpConfigStorage)this.wxMpConfigStorageBuilder.builder(account));
        return service;
    }
}

