/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.wechat.service.impl;

import com.bxm.newidea.component.wechat.config.WechatMpAccount;
import com.bxm.newidea.component.wechat.config.WechatMpContext;
import com.bxm.newidea.component.wechat.param.WechatOnAuth2UrlParam;
import com.bxm.newidea.component.wechat.param.WxMpJsSignatureParam;
import com.bxm.newidea.component.wechat.service.WechatMpService;
import java.util.Arrays;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatMpServiceImpl
implements WechatMpService {
    private static final Logger log = LoggerFactory.getLogger(WechatMpServiceImpl.class);
    private final WechatMpContext context;

    @Autowired
    public WechatMpServiceImpl(WechatMpContext context) {
        this.context = context;
    }

    @Override
    public String acquireAuthUrl(WechatOnAuth2UrlParam param) {
        WxMpService wxMpService = this.context.obtain(param.getScene());
        if (wxMpService == null) {
            return null;
        }
        WechatMpAccount wechatMpAccount = this.context.obtainAccount(wxMpService);
        Object[] authDomainUrls = wechatMpAccount.getAuthDomainUrls().toArray(new String[0]);
        if (!StringUtils.startsWithAny((CharSequence)param.getRedirectURI(), (CharSequence[])authDomainUrls)) {
            log.error("\u83b7\u53d6\u5fae\u4fe1\u6388\u6743\u5730\u5740\u7684\u56de\u8c03\u5730\u5740\u4e0e\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e\u7684\u6388\u6743\u57df\u540d\u4e0d\u5339\u914d\uff0c\u573a\u666f\u503c\uff1a[{}],\u5fae\u4fe1\u516c\u4f17\u53f7\uff1a[{} - {} ]\uff0c\u8bf7\u6c42\u57df\u540d\uff1a[{}]\uff0c\u914d\u7f6e\u7684\u5b89\u5168\u57df\u540d:[{}]", new Object[]{param.getScene(), wechatMpAccount.getAlias(), wechatMpAccount.getAppId(), param.getRedirectURI(), Arrays.toString(authDomainUrls)});
        }
        String authUrl = String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&connect_redirect=1#wechat_redirect", wxMpService.getWxMpConfigStorage().getAppId(), param.getRedirectURI(), param.getScope(), StringUtils.trimToEmpty((String)param.getState()));
        log.debug("\u573a\u666f[{}]\u5bf9\u5e94\u7684[{}]\u751f\u6210\u6700\u7ec8\u6388\u6743URL\u4e3a\uff1a{}", new Object[]{param.getScene(), param.getRedirectURI(), authUrl});
        return authUrl;
    }

    @Override
    public WxJsapiSignature acquireJsSignature(WxMpJsSignatureParam param) {
        WxMpService wxMpService = this.context.obtain(param.getScene());
        if (wxMpService == null) {
            return null;
        }
        try {
            WechatMpAccount wechatMpAccount = this.context.obtainAccount(wxMpService);
            Object[] jsDomainUrls = wechatMpAccount.getJsSignatureDomainUrls().toArray(new String[0]);
            if (!StringUtils.startsWithAny((CharSequence)param.getUrl(), (CharSequence[])jsDomainUrls)) {
                log.error("\u83b7\u53d6\u5fae\u4fe1\u8bf7\u6c42\u7b7e\u540d\u7684\u4e0e\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e\u7684js\u8ba4\u771f\u57df\u540d\u4e0d\u5339\u914d\uff0c\u573a\u666f\u503c\uff1a[{}],\u5fae\u4fe1\u516c\u4f17\u53f7\uff1a[{} - {} ]\uff0c\u8bf7\u6c42\u57df\u540d\uff1a[{}]\uff0c\u914d\u7f6e\u7684\u5b89\u5168\u57df\u540d:[{}]", new Object[]{param.getScene(), wechatMpAccount.getAlias(), wechatMpAccount.getAppId(), param.getUrl(), Arrays.toString(jsDomainUrls)});
            }
            log.debug("\u6839\u636e[{}]\u83b7\u53d6js\u7b7e\u540d\u4fe1\u606f\uff0c\u4f7f\u7528\u7684\u516c\u4f17\u53f7ID\u4e3a\uff1a{}", (Object)param.getScene());
            return wxMpService.createJsapiSignature(param.getUrl());
        }
        catch (WxErrorException e) {
            log.error("\u83b7\u53d6\u7b7e\u540d\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public WxMpUser exchangeWxMapUser(String scene, String authCode) {
        WxMpService wxMpService = this.context.obtain(scene);
        if (wxMpService == null) {
            return null;
        }
        WxMpOAuth2AccessToken wxMpOAuth2AccessToken = null;
        try {
            wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(authCode);
            WxMpUser wxMpUser = wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            log.debug("\u83b7\u53d6\u5fae\u4fe1\u4fe1\u606f\u6210\u529f\uff0cscene\uff1a{},authCode:{},wechatNickName:{},appId:{}", new Object[]{scene, authCode, wxMpUser.getNickname(), wxMpService.getWxMpConfigStorage().getAppId()});
            return wxMpUser;
        }
        catch (WxErrorException e) {
            log.error("\u6839\u636ecode\u83b7\u53d6\u5fae\u4fe1\u4fe1\u606f\u5931\u8d25,\u573a\u666f\uff1a[{}],\u6388\u6743\u7801\u4e3a:[{}],\u5bf9\u5e94\u7684APPID\u4e3a\uff1a[{}]", new Object[]{scene, authCode, wxMpService.getWxMpConfigStorage().getAppId()});
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

