package com.bxm.newidea.component.wechat.config;

import lombok.Data;
import lombok.ToString;

import java.util.List;

/**
 * 微信公众号的配置信息
 */
@ToString
@Data
public class WechatMpAccount {
    /**
     * 公众号ID
     */
    private String appId;

    /**
     * 当前公众号的别名，用于区分不同公众号的来源，防止错乱
     */
    private String alias;

    /**
     * 公众号密钥
     */
    private String appSecret;

    /**
     * aesKey : 微信公众号自动回复、修改菜单栏等需要此配置
     */
    private String aesKey;

    /**
     * 公众号是否处于启用状态（审核、异常等情况，可以选择暂时关闭）
     */
    private Boolean enable;

    /**
     * 公众号配置的授权域名列表
     * 请求域名授权时检查，如果不匹配则提示调用者，不做强制处理
     */
    private List<String> authDomainUrls;

    /**
     * 公众号配置的js签名对应的域名列表
     * 请求js签名时检查，如果不匹配则提示调用者，但不做强制处理
     */
    private List<String> jsSignatureDomainUrls;
}