package com.bxm.newidea.component.wechat.service.impl;

import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.wechat.config.WechatMpAccount;
import com.bxm.newidea.component.wechat.extend.CustomApacheHttpClientBuilder;
import com.bxm.newidea.component.wechat.extend.WxMpInRedisConfigStorage;
import com.bxm.newidea.component.wechat.service.WxMpConfigStorageBuilder;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;

public class WxMpRedisConfigStorageBuilder implements WxMpConfigStorageBuilder {

    private RedisStringAdapter redisStringAdapter;

    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;

    public WxMpRedisConfigStorageBuilder(RedisStringAdapter redisStringAdapter, CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.redisStringAdapter = redisStringAdapter;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
    }

    @Override
    public WxMpInMemoryConfigStorage builder(WechatMpAccount account) {
        WxMpInMemoryConfigStorage wxConfigProvider = new WxMpInRedisConfigStorage(redisStringAdapter, customApacheHttpClientBuilder);
        wxConfigProvider.setAppId(account.getAppId());
        wxConfigProvider.setSecret(account.getAppSecret());
        wxConfigProvider.setAesKey(account.getAesKey());
        return wxConfigProvider;
    }
}
