package com.bxm.newidea.component.schedule.rpc.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.rpc.ScheduleFeignService;
import com.bxm.newidea.component.schedule.rpc.param.XxlJobGroup;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 使用http请求xxl调度服务
 * @author liujia
 * @date 2020/04/22 16:45
 */
@Slf4j
public class ScheduleFeignServiceImpl implements ScheduleFeignService {

    private XxlJobConfigurationProperties properties;

    public ScheduleFeignServiceImpl(XxlJobConfigurationProperties properties) {
        this.properties = properties;
    }

    @Override
    public void add(String jobName, String jobCron, String jobDesc,
                    String executorName, String executorHandler,
                    String executorParam, String executorRouteStrategy,
                    String executorBlockStrategy, String author) {
        String addUrl = buildPath("facade/jobInfo/add");

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("jobName", jobName);
        paramMap.put("jobCron", jobCron);
        paramMap.put("jobDesc", jobDesc);
        paramMap.put("executorName", executorName);
        paramMap.put("executorHandler", executorHandler);
        paramMap.put("executorParam", executorParam);
        paramMap.put("executorRouteStrategy", executorRouteStrategy);
        paramMap.put("executorBlockStrategy", executorBlockStrategy);
        paramMap.put("author", author);

        String response = OkHttpUtils.postForm(addUrl, paramMap, null);
        log.info("创建定时任务，请求参数：{}，响应结果：{}", JSON.toJSONString(paramMap), response);
    }

    private String buildPath(String uri) {
        if (StringUtils.endsWith(properties.getAdminAddresses(), "/")) {
            return properties.getAdminAddresses() + uri;
        }
        return properties.getAdminAddresses() + "/" + uri;
    }

    @Override
    public void update(String jobName, String jobCron, String jobDesc,
                       String executorName, String executorHandler,
                       String executorParam, String executorRouteStrategy,
                       String executorBlockStrategy, String author) {
        String addUrl = buildPath("facade/jobInfo/update");

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("jobName", jobName);
        paramMap.put("jobCron", jobCron);
        paramMap.put("jobDesc", jobDesc);
        paramMap.put("executorName", executorName);
        paramMap.put("executorHandler", executorHandler);
        paramMap.put("executorParam", executorParam);
        paramMap.put("executorRouteStrategy", executorRouteStrategy);
        paramMap.put("executorBlockStrategy", executorBlockStrategy);
        paramMap.put("author", author);

        String response = OkHttpUtils.postForm(addUrl, paramMap, null);
        log.debug("更新定时任务，请求参数：{}，响应结果：{}", JSON.toJSONString(paramMap), response);
    }

    @Override
    public void remove(String jobName) {
        String addUrl = buildPath("facade/jobInfo/remove");

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("jobName", jobName);

        String response = OkHttpUtils.postForm(addUrl, paramMap, null);
        log.info("移除定时任务，请求参数：{}，响应结果：{}", JSON.toJSONString(paramMap), response);
    }

    @Override
    public void regJobGroup(XxlJobGroup jobGroup) {
        String addUrl = buildPath("facade/jobInfo/reg/job");
        String requestBody = JSON.toJSONString(jobGroup);
        String response = OkHttpUtils.postJsonBody(addUrl, requestBody, null);

        log.info("注册执行器，请求参数：{}，响应结果：{}", requestBody, response);
    }
}
