package com.bxm.newidea.component.schedule.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author liujia
 * @date 2020/04/22 16:13
 */
@ConfigurationProperties(prefix = "xxl.job.executor")
@Data
public class XxlJobConfigurationProperties {

    static int DEFAULT_PORT = 19099;

    /**
     * 调度服务地址，多个地址使用英文逗号分隔
     * 必须配置
     */
    private String adminAddresses;

    /**
     * 当前应用的名称
     * 如未配置则将获取当前服务的默认服务名
     */
    @Value("${spring.application.name:undefined}")
    private String appName;

    /**
     * 引用该模块的服务部署设备实际IP，用于调度服务回调
     * 如未配置将尝试通过网卡获取
     */
    private String ip;

    /**
     * 对调度服务暴露的端口，用于调度服务回调
     * 如未配置将使用默认端口，注意多服务部署时的端口冲突
     */
    private int port = DEFAULT_PORT;

    /**
     * 访问凭证，如果配置需要与调度服务保持一致，用于安全性数据传输
     * 非必须，可以为空
     */
    private String accessToken;

    /**
     * log file path
     */
    private String logPath = "/opt/logs/job/";

    /**
     * 定期清理执行日志
     */
    private int logRetentionDays = 3;

    /**
     * enable mock service
     */
    private boolean mock = false;

    /**
     * 所有任务的默认版本后缀，具有较低的全局优先级
     */
    private String version = "1.0.0";
}
