/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.config;

import com.bxm.newidea.component.schedule.OnceJobExecutor;
import com.bxm.newidea.component.schedule.config.ComponentXxlJobExecutor;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.config.XxlJobExecutorExtend;
import com.bxm.newidea.component.tools.NetworkInterfaceManager;
import com.xxl.job.core.executor.XxlJobExecutor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={XxlJobConfigurationProperties.class})
public class XxlJobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XxlJobConfiguration.class);
    private final XxlJobConfigurationProperties properties;
    private static final String EXECUTOR_IP = "executorIp";

    public XxlJobConfiguration(XxlJobConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean(destroyMethod="destroy")
    public XxlJobExecutor xxlJobExecutor() {
        ComponentXxlJobExecutor xxlJobExecutor = new ComponentXxlJobExecutor();
        if (this.properties.isMock()) {
            log.info("\u5f53\u524d\u4f7f\u7528\u6a21\u62df\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5668\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316");
            return xxlJobExecutor;
        }
        if (StringUtils.isBlank((String)this.properties.getAppName())) {
            throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.app-name\u914d\u7f6e\u5c5e\u6027");
        }
        String ip = System.getProperty(EXECUTOR_IP);
        if (StringUtils.isBlank((String)ip)) {
            ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
            if (null == ip) {
                throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.ip\u914d\u7f6e\u5c5e\u6027");
            }
            xxlJobExecutor.setIp(ip);
        }
        if (StringUtils.isBlank((String)this.properties.getAdminAddresses())) {
            throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.adminAddresses\u914d\u7f6e\u5c5e\u6027");
        }
        if (XxlJobConfigurationProperties.DEFAULT_PORT == this.properties.getPort()) {
            log.info("\u8c03\u5ea6\u670d\u52a1\u56de\u8c03\u63a5\u53e3\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684[{}]\u7aef\u53e3\uff0c\u8bf7\u6ce8\u610f\u90e8\u7f72\u65f6\u7684\u7aef\u53e3\u51b2\u7a81\u95ee\u9898", (Object)this.properties.getPort());
        }
        int port = this.properties.getPort();
        if (this.properties.getPort() <= 0) {
            port = this.properties.getAppPort() + 1000;
            log.info("\u672a\u914d\u7f6e\u66b4\u9732\u7684xxl-job\u670d\u52a1\u7aef\u53e3\uff0c\u4f7f\u7528\uff1a{}", (Object)port);
        }
        xxlJobExecutor.setAdminAddresses(this.properties.getAdminAddresses());
        xxlJobExecutor.setAppname(this.properties.getAppName());
        xxlJobExecutor.setPort(port);
        xxlJobExecutor.setAccessToken(this.properties.getAccessToken());
        xxlJobExecutor.setLogPath(this.properties.getLogPath());
        xxlJobExecutor.setLogRetentionDays(this.properties.getLogRetentionDays());
        xxlJobExecutor.setXxlJobExecutorExtend(this.xxlJobExecutorExtend());
        try {
            xxlJobExecutor.start();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return xxlJobExecutor;
    }

    @Bean
    public OnceJobExecutor onceJobExecutor(XxlJobExecutorExtend xxlJobExecutorExtend) {
        return new OnceJobExecutor(this.properties, xxlJobExecutorExtend);
    }

    @Bean
    public XxlJobExecutorExtend xxlJobExecutorExtend() {
        return new XxlJobExecutorExtend(this.properties);
    }
}

