/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.config;

import cn.hutool.core.util.NumberUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.AbstractOnceXxlJob;
import com.bxm.newidea.component.schedule.config.ComponentXxlJobExecutor;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.job.BaseJobHandler;
import com.bxm.newidea.component.schedule.job.IXxlJobHandlerDefinition;
import com.bxm.newidea.component.schedule.model.BaseOnceJobParam;
import com.bxm.newidea.component.schedule.model.CancelOnceJobParam;
import com.bxm.newidea.component.schedule.model.JobPersistentObject;
import com.bxm.newidea.component.schedule.model.XxlJobGroup;
import com.bxm.newidea.component.schedule.model.XxlJobInfo;
import com.google.common.base.Splitter;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.util.XxlJobRemotingUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XxlJobExecutorExtend
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(XxlJobExecutorExtend.class);
    private XxlJobConfigurationProperties properties;
    private String accessToken;
    private String firstAdminAddress;
    private Integer groupId;
    private ApplicationContext applicationContext;
    private ComponentXxlJobExecutor executor;

    XxlJobExecutorExtend(XxlJobConfigurationProperties properties) {
        this.properties = properties;
        this.accessToken = properties.getAccessToken();
        this.firstAdminAddress = (String)Splitter.on((String)",").split((CharSequence)properties.getAdminAddresses()).iterator().next();
        if (!this.firstAdminAddress.endsWith("/")) {
            this.firstAdminAddress = this.firstAdminAddress + "/";
        }
    }

    void init(ComponentXxlJobExecutor executor) {
        this.executor = executor;
        this.registryGroup();
        if (this.groupId != null) {
            this.registryTask();
        }
    }

    private void registryGroup() {
        XxlJobGroup group = new XxlJobGroup();
        group.setAppname(this.properties.getAppName());
        group.setTitle(this.properties.getAppName());
        group.setAddressType(0);
        ReturnT response = XxlJobRemotingUtil.postBody((String)(this.firstAdminAddress + "api/group"), (String)this.accessToken, (int)3, (Object)group, String.class);
        if (response.getCode() == 200) {
            Object responseObj = response.getContent();
            if (responseObj != null) {
                this.groupId = NumberUtil.parseInt((String)responseObj.toString());
            } else {
                log.error("xxl-job\u670d\u52a1\u7aef\u6ce8\u518c\u670d\u52a1\u65f6\u6ca1\u6709\u8fd4\u56degroupId,\u65e0\u6cd5\u542f\u52a8\u5f53\u524d\u6a21\u5757");
            }
        } else {
            log.error("\u5f53\u524d\u5e94\u7528\u6ce8\u518c\u5931\u8d25\uff0c\u5b9a\u65f6\u4efb\u52a1\u76f8\u5173\u6a21\u5757\u672a\u542f\u52a8\u6210\u529f\uff0c\u9519\u8bef\u6d88\u606f\uff1a{}", (Object)response.getMsg());
        }
    }

    private void registryTask() {
        Collection<BaseJobHandler> handlerCollection = this.scanJob();
        List jobInfoList = handlerCollection.stream().map(this::convert).collect(Collectors.toList());
        ReturnT response = XxlJobRemotingUtil.postBody((String)(this.firstAdminAddress + "api/addJobs"), (String)this.accessToken, (int)3, jobInfoList, String.class);
        if (response.getCode() == 200) {
            handlerCollection.forEach(jobInfo -> {
                ComponentXxlJobExecutor.registJobHandler((String)jobInfo.executorHandler(), (IJobHandler)jobInfo);
                log.info("\u6ce8\u518c\u5b9a\u65f6\u4efb\u52a1[{} - {}]\u6210\u529f", (Object)jobInfo.executorHandler(), (Object)jobInfo.jobDesc());
            });
        } else {
            log.error("\u4efb\u52a1\u6ce8\u518c\u5931\u8d25\uff0c\u9519\u8bef\u6d88\u606f\uff1a{}", (Object)response.getMsg());
        }
    }

    public <T extends BaseOnceJobParam> void submitOnceJob(Class<? extends AbstractOnceXxlJob> onceXxlJobClass, JobPersistentObject param) {
        ReturnT response = XxlJobRemotingUtil.postBody((String)(this.firstAdminAddress + "api/onceJob"), (String)this.accessToken, (int)3, (Object)param, String.class);
        if (response.getCode() != 200) {
            log.error("{}\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u9519\u8bef\u539f\u56e0\uff1a{}", new Object[]{onceXxlJobClass, JSON.toJSONString((Object)param), response.getMsg()});
        }
    }

    public boolean cancelOnceJob(Class<? extends AbstractOnceXxlJob> onceXxlJobClass, CancelOnceJobParam param) {
        ReturnT response = XxlJobRemotingUtil.postBody((String)(this.firstAdminAddress + "api/cancelOnceJob"), (String)this.accessToken, (int)3, (Object)param, String.class);
        if (response.getCode() != 200) {
            log.error("{}\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{},\u9519\u8bef\u539f\u56e0\uff1a{}", new Object[]{onceXxlJobClass, JSON.toJSONString((Object)param), response.getMsg()});
            return false;
        }
        Object content = response.getContent();
        if (null == content) {
            return false;
        }
        return Boolean.TRUE.equals(Boolean.parseBoolean(content.toString()));
    }

    private XxlJobInfo convert(IXxlJobHandlerDefinition definition) {
        XxlJobInfo jobInfo = new XxlJobInfo();
        jobInfo.setJobGroup(this.groupId);
        jobInfo.setJobDesc(definition.jobDesc());
        jobInfo.setGlueType("BEAN");
        jobInfo.setAlarmEmail(this.properties.getAlarmEmail());
        jobInfo.setAuthor(definition.author());
        jobInfo.setScheduleType(definition.scheduleType().name());
        jobInfo.setScheduleConf(definition.scheduleConf());
        jobInfo.setMisfireStrategy(definition.misfireStrategy().name());
        jobInfo.setExecutorHandler(definition.executorHandler());
        jobInfo.setExecutorParam(definition.executorParam());
        jobInfo.setExecutorBlockStrategy(definition.executorBlockStrategy().name());
        jobInfo.setExecutorRouteStrategy(definition.executorRouteStrategy().name());
        jobInfo.setExecutorFailRetryCount(definition.executorFailRetryCount());
        jobInfo.setExecutorTimeout(definition.executorTimeout());
        return jobInfo;
    }

    private Collection<BaseJobHandler> scanJob() {
        Map jobHandlerMap = this.applicationContext.getBeansOfType(BaseJobHandler.class);
        log.info("\u626b\u63cf\u5230{}\u4e2a\u5b9a\u65f6\u4efb\u52a1\uff0c\u8fdb\u884c\u521d\u59cb\u5316\u914d\u7f6e", (Object)jobHandlerMap.size());
        return jobHandlerMap.values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

