package com.bxm.newidea.component.schedule.register.impl;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.register.ScheduleRegisterService;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import lombok.extern.slf4j.Slf4j;

/**
 * 默认的调度远程服务实现
 *
 * @author liujia
 */
@Slf4j
public class DefaultScheduleRegisterService implements ScheduleRegisterService {
    @Override
    public void add(ScheduleTask task) {
        log.debug("new schedule,job info:{}", JSON.toJSONString(task));
    }

    @Override
    public void update(ScheduleTask task) {
        log.debug("modify schedule,job info:{}", JSON.toJSONString(task));
    }

    @Override
    public void remove(ScheduleTask task) {
        log.debug("remove schedule,job info:{}", JSON.toJSONString(task));

    }
}
