package com.bxm.newidea.component.schedule.handler;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.constant.XxljobConstant;
import com.bxm.newidea.component.schedule.param.ExecutorParam;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.XxlJob;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.HashMap;
import java.util.Map;

/**
 * 任务Handler（Bean模式）
 * <p>
 * 开发步骤：
 * 1、继承"IJobHandler"：“com.xxl.job.core.handler.IJobHandler”；
 * 2、注册到Spring容器：添加“@Component”注解，被Spring容器扫描为Bean实例；
 * 3、注册到执行器工厂：添加“@JobHandler(value="自定义jobhandler名称")”注解，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 4、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 *
 * @author liujia
 */
public class BeanByNameHandler extends IJobHandler implements ApplicationContextAware, ApplicationRunner {

    private ApplicationContext applicationContext;

    private Map<String, TaskCallback> callbackMap;

    @Override
    @XxlJob(value = XxljobConstant.HANDLER_NAME)
    public void execute() {
        String param = XxlJobHelper.getJobParam();
        XxlJobHelper.log(param);

        if (StringUtils.isBlank(param)) {
            XxlJobHelper.handleFail("参数不能为空！");
            return;
        }

        ExecutorParam executorParam = JSON.parseObject(param, ExecutorParam.class);
        if (null == executorParam || StringUtils.isBlank(executorParam.getBeanName())) {
            XxlJobHelper.handleFail("参数格式错误，缺少bean名或者参数类型不是{ExecutorParam}");
            return;
        }

        TaskCallback<?> callback;
        try {
            callback = callbackMap.get(executorParam.getBeanName());
        } catch (Exception e) {
            XxlJobHelper.handleFail("类" + executorParam.getBeanName() + "不存在");
            return;
        }

        ReturnT<String> execute = callback.execute(executorParam.getParams());
        if (null == execute || ReturnT.SUCCESS.getCode() == execute.getCode()) {
            if (null == execute) {
                XxlJobHelper.handleSuccess();
            } else {
                XxlJobHelper.handleSuccess(execute.getMsg());
            }
        } else {
            XxlJobHelper.handleFail(execute.getMsg());
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void run(ApplicationArguments args) {
        callbackMap = new HashMap<>();
        Map<String, TaskCallback> beansOfType = applicationContext.getBeansOfType(TaskCallback.class);

        beansOfType.values().forEach(callbackBean -> {
            callbackMap.put(callbackBean.beanName(), callbackBean);
        });
    }
}
