package com.bxm.newidea.component.zk.listener;

import org.apache.zookeeper.data.Stat;

/**
 * 监听节点变更事件，同时对子节点相关状态进行监听
 *
 * @author liujia
 * @date 6/7/21 12:30 PM
 **/
public interface NodeChangeWithChildrenListener extends NodeChangeListener {

    /**
     * 新增子节点
     *
     * @param path 子节点路径
     * @param data 子节点存储的数据
     * @param stat 监听的节点的状态信息
     */
    void added(String path, String data, Stat stat);

    /**
     * 移除子节点
     *
     * @param path 子节点路径
     * @param data 子节点存储数据
     * @param stat 监听的节点的状态信息
     */
    void removed(String path, String data, Stat stat);
}
