package com.bxm.newidea.component.zk.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author liujia
 * @date 6/7/21 9:24 AM
 **/
@ConfigurationProperties(prefix = "component.zk")
@Data
public class ComponentZkConfigurationProperties {

    /**
     * zookeeper的连接地址,多个实例使用逗号分隔
     */
    private String url;

    /**
     * 密码鉴权
     */
    private String digest;

    /**
     * session超时时间，如果时间段内没有完成访问，则会抛出异常
     */
    private int sessionTimeout = 3000;

    /**
     * 连接zookeeper的超时时间(毫秒)
     */
    private int connectionTimeout = 5000;

    /**
     * 命名空间，逻辑分区
     */
    private String namespace;
}
