package com.bxm.localnews.news.action.stream;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

/**
 * spring cloud steam的输出通道定义
 * 配置
 *
 * @author liujia
 * @date 2020-07-16 15:30
 **/
public interface MessageProcessor {

    /**
     * 用户发表评论
     */
    String COMMENT_OUTPUT = "commentOutput";

    /**
     * 用户发布帖子
     */
    String FORUM_POST_OUTPUT = "forumPostOutput";

    /**
     * 用户发布小纸条
     */
    String NOTE_OUTPUT = "noteOutput";

    /**
     * 用户分享新闻内容
     */
    String SHARE_OUTPUT = "shareOutput";


    /**
     * 用户分享帖子内容
     */
    String SHARE_FORUM_OUTPUT = "shareForumOutput";

    /**
     * 用户查看帖子或新闻
     */
    String VIEW_OUTPUT = "viewOutput";

    /**
     * 用户收藏、取消收藏
     */
    String COLLECT_OUTPUT = "collectOutput";

    /**
     * 用户位置信息变更
     */
    String USER_LOCATION_INPUT = "userLocationInput";

    /**
     * 用户冗余信息更新
     */
    String USER_REDUNDANCY_INPUT = "userRedundancyInput";

    @Output(MessageProcessor.COMMENT_OUTPUT)
    MessageChannel commentOutput();

    @Output(MessageProcessor.FORUM_POST_OUTPUT)
    MessageChannel forumPostOutput();

    @Output(MessageProcessor.NOTE_OUTPUT)
    MessageChannel noteOutput();

    @Output(MessageProcessor.SHARE_OUTPUT)
    MessageChannel shareOutput();

    @Output(MessageProcessor.SHARE_FORUM_OUTPUT)
    MessageChannel shareForumOutput();

    @Output(MessageProcessor.VIEW_OUTPUT)
    MessageChannel viewOutput();

    @Output(MessageProcessor.COLLECT_OUTPUT)
    MessageChannel collectOutput();

    @Input(USER_LOCATION_INPUT)
    SubscribableChannel userLocationInput();

    @Input(USER_REDUNDANCY_INPUT)
    SubscribableChannel userRedundancyInput();
}
