package com.bxm.localnews.news.controller;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.list.PostListService;
import com.bxm.localnews.news.model.dto.ShareContentDTO;
import com.bxm.localnews.news.model.param.FollowUserForumsParam;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import com.bxm.localnews.news.model.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.model.param.HomePagePostParam;
import com.bxm.localnews.news.model.vo.FollowUserForumPostVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.service.ShareRankService;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

@Api(tags = "9-01 帖子的各种列表接口")
@RestController
@RequestMapping("{version}/news/list")
@AllArgsConstructor
public class ForumListController extends BaseController {

    private PostListService postListService;

    private final ShareRankService shareRankService;

    @ApiOperation(value = "9-01-1 [v1]获取不同场景下的帖子列表", notes = "场景包括：0热门 1精选 2最新 3社区首页")
    @GetMapping(value = "getPostPage")
    @ApiVersion(1)
    public Json<PageWarper<ForumPostVo>> getPostPage(@Valid ForumPostListQueryParam param) {
        return ResultUtil.genSuccessResult(postListService.listForumPost(param));
    }

    @ApiOperation(value = "9-01-2 [v1]获取用户发帖列表", notes = "在私聊、我的帖子、我的收藏中显示用户的对应帖子信息")
    @GetMapping(value = "security/getPostPageByUser")
    @ApiVersion(1)
    public Json<PageWarper<ForumPostVo>> getPostPageByUser(ForumPostListUserQueryParam param) {
        return ResultUtil.genSuccessResult(postListService.listForumPostByUser(param));
    }


    @ApiOperation(value = "9-01-3 [v1]关注用户帖子列表", notes = "在本地圈-关注tab中显示当前用户关注的用户发帖信息")
    @GetMapping(value = "followUserForums")
    @ApiVersion(1)
    public ResponseJson<FollowUserForumPostVo> followUserForums(@Valid FollowUserForumsParam param, BasicParam basicParam) {
        return ResponseJson.ok(postListService.getFollowedUserForumList(param, basicParam));
    }

    @ApiOperation(value = "9-01-4 [v1]个人主页 帖子列表", notes = "进入个人主页后显示帖子列表，分为主态和客态")
    @GetMapping(value = "getHomePagePostList")
    @ApiVersion(1)
    public Json<PageWarper<ForumPostVo>> getHomePagePostList(HomePagePostParam param, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(postListService.getHomePagePostList(param, basicParam));
    }


    @ApiOperation(value = "9-01-5 [v1]根据帖子id列表获取帖子列表", notes = "暂时不知道哪里调用到了")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postIds", value = "帖子id列表，逗号分隔", required = true)
    })
    @GetMapping(value = "public/getPostListByIds")
    public Json<List<ForumPostVo>> getPostListByIds(String postIds) {
        return ResultUtil.genSuccessResult(postListService.getPostListByIds(postIds));
    }

    @ApiOperation(value = "9-01-6 [v1]获取某地区阅读排行靠前的内容，用于分享", notes = "需要分享帖子的地方，获取当前区域可用于分享的一些帖子")
    @GetMapping("top")
    @ApiVersion(1)
    public ResponseJson<List<ShareContentDTO>> getTopToShare(BaseAreaCodeParam param) {
        return ResponseJson.ok(shareRankService.getTopPost(param.getAreaCode()));
    }

//    @ApiOperation(value = "9-01-21 获取爆料有奖页面地址")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "isLogin", value = "是否登录", required = false),
//            @ApiImplicitParam(name = "userId", value = "用户id", required = false),
//            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = false)
//    })
//    @GetMapping(value = "getPublishRewardUrl")
//    public Json<String> getPublishRewardUrl(@RequestParam(value = "isLogin", required = false) String isLogin,
//                                            @RequestParam(value = "userId", required = false) String userId,
//                                            @RequestParam(value = "areaCode", required = false) String areaCode) {
//        return ResultUtil.genSuccessResult(forumProperties.getPublishRewardUrl()
//                + "?isLogin=" + isLogin + "&userId=" + userId + "&areaCode=" + areaCode);
//    }

//    @ApiOperation(value = "9-01-25 用户今日是否发帖浮窗接口", notes = "用户今日是否发帖接口", httpMethod = "GET", nickname = "wpf")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
//    })
//    @GetMapping(value = "forumOkTodayForUser")
//    public ResponseJson<ForumPostTodayDTO> forumOkTodayForUser(Long userId) {
//        return ResponseJson.ok(forumPostGuideService.forumOkTodayForUser(userId));
//    }

//    @ApiOperation(value = "9-01-26 热门帖子内容榜", notes = "热门帖子内容榜", httpMethod = "GET", nickname = "wpf")
//    @GetMapping(value = "public/getHotForums")
//    public ResponseJson<PageWarper<HotForumPostVo>> getHotForums(HotForumsParam param, BasicParam basicParam) {
//
//        return ResponseJson.ok(hotPostService.hotForumPost(param, basicParam));
//    }
//
//    @ApiOperation(value = "9-01-27 热门帖子分享基本信息", notes = "热门帖子分享基本信息", httpMethod = "GET", nickname = "wpf")
//    @GetMapping(value = "getHotForumShareInfo")
//    public ResponseJson<HotForumListShareDTO> hotForumsShareBaseInfo(HotForumListShareParam param) {
//        return ResponseJson.ok(hotPostService.hotForumsShareBaseInfo(param));
//    }


//    @ApiOperation(value = "9-01-15 帖子详情相关推荐", notes = "如果是15条，则5条本地新闻 10条帖子，如果是5条，则2条本地，3条帖子")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true),
//            @ApiImplicitParam(name = "userId", value = "用户ID"),
//            @ApiImplicitParam(name = "areaCode", value = "地区编号"),
//            @ApiImplicitParam(name = "size", value = "推荐个数")
//    })
//    @GetMapping(value = "detail/recommend")
//    public Json<List<News4Client>> recommend(@RequestParam(value = "postId", required = false) Long postId,
//                                             @RequestParam(value = "userId", required = false) Long userId,
//                                             @RequestParam(value = "areaCode", required = false) String areaCode,
//                                             @RequestParam(value = "size", required = false) Integer size,
//                                             @RequestParam(value = "platform", required = false) Integer platform) {
//        return ResultUtil.genSuccessResult(postRecommendIntegrationService.listPostDetailRecommend(postId, userId, size, areaCode, platform));
//    }
}
