package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.action.*;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.model.dto.PostLikeDto;
import com.bxm.localnews.news.model.entity.ForumPostCollectEntity;
import com.bxm.localnews.news.model.param.ForumPostCollectParam;
import com.bxm.localnews.news.model.param.ForumPostInformParam;
import com.bxm.localnews.news.model.param.NewsShieldParam;
import com.bxm.localnews.news.model.param.action.PostLikeSaveParam;
import com.bxm.localnews.news.model.param.action.SharePostParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Api(tags = "9-02 帖子相关用户行为接口", description = "相关操作都必须要用户登录以后操作")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/news/security/action")
public class ForumPostActionController {

    private PostShareService postShareService;

    private PostCollectService newsCollectService;

    private PostReportService postReportService;

    private PostLikeService postLikeService;

    private NewsShieldService newsShieldService;

    @ApiOperation(value = "9-02-1 [v1]收藏或取消收藏帖子", notes = "帖子详情的二级菜单中，可以选择收藏或取消收藏")
    @RequestMapping(value = "collect", method = RequestMethod.POST)
    @ApiVersion(1)
    public ResponseJson collect(@RequestBody ForumPostCollectParam param) {
        ForumPostCollectEntity entity = new ForumPostCollectEntity();
        entity.setPostId(param.getPostId());
        entity.setUserId(param.getUserId());

        this.newsCollectService.collectNews(entity);
        return ResponseJson.ok().build();
    }

    @ApiOperation(value = "9-02-2 [v1]帖子举报", notes = "帖子右上角，点击举报，填写举报信息")
    @RequestMapping(value = "inform", method = RequestMethod.POST)
    @ApiVersion(1)
    public ResponseJson inform(@RequestBody ForumPostInformParam forumPostInformParam) {
        return ResponseJson.ok(this.postReportService.doInformForumPost(forumPostInformParam));
    }

    @ApiOperation(value = "9-02-3 [v1]用户分享帖子", notes = "现在分享已经不给金币了，主要是记录分享数据")
    @RequestMapping(value = "share", method = RequestMethod.POST)
    @ApiVersion(1)
    public ResponseJson<NewsCompleTaskDTO> share(@RequestBody SharePostParam param) {
        return ResponseJson.ok(this.postShareService.doShareForumPost(param));
    }

    @ApiOperation(value = "9-02-4 [v1]帖子点赞", notes = "帖子点赞，无法取消点赞哦亲")
    @PostMapping("new/like")
    @ApiVersion(1)
    public ResponseJson<PostLikeDto> newLike(@RequestBody PostLikeSaveParam param) {
        PostLikeDto postLikeDto = postLikeService.doLikeForumPost(param);
        if (null != postLikeDto) {
            return ResponseJson.ok(postLikeDto);
        } else {
            return ResponseJson.badReqeuset().build();
        }
    }

    @ApiOperation(value = "9-02-5 [v1]屏蔽帖子", notes = "帖子右上角，点击屏蔽")
    @PostMapping(value = "shield")
    @ApiVersion(1)
    public ResponseJson shield(@RequestBody @Valid NewsShieldParam newsShieldParam) {
        newsShieldService.save(newsShieldParam);
        return ResponseJson.ok().build();
    }
}