package com.bxm.localnews.news.controller;

import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.activity.GrainTotalService;
import com.bxm.localnews.news.detail.ForumPostDetailService;
import com.bxm.localnews.news.detail.context.PostDetailOriginalParam;
import com.bxm.localnews.news.model.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Api(tags = "9-03 内容详情相关接口")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/news/detail")
public class ForumPostDetailController {

    private ForumPostDetailService forumPostDetailService;

    private PostLikeService postLikeService;

     private GrainTotalService grainTotalService;

    @ApiOperation(value = "9-03-1 [v1]根据id获取帖子详情", notes = "站内、站外都是走这个接口")
    @GetMapping(value = "getPostDetailById")
    @ApiVersion(1)
    public Json<ForumPostVo> getPostDetailById(PostDetailOriginalParam param, HttpServletRequest request) {
        param.setBasicParam(param);
        param.setIp(WebUtils.getIpAddr(request));
        grainTotalService.addVisibleNumByPostDetail(param.getId());
        return ResultUtil.genSuccessResult(forumPostDetailService.get(param));
    }

    @ApiOperation(value = "9-03-2 [v1]根据帖子id获得点赞列表", notes = "帖子详情中点击点赞信息加载更多")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "devcId", value = "设备id", required = false)
    })
    @GetMapping(value = "getPostLikeDetailById")
    @ApiVersion(1)
    public Json<List<ForumPostLikeDTO>> getPostLikeDetailById(Long postId, Long userId, String devcId) {
        return ResultUtil.genSuccessResult(postLikeService.getPostLikeDetail(postId, userId, devcId));
    }
}