package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.create.PostCreateService;
import com.bxm.localnews.news.model.dto.ForumPostCreateDTO;
import com.bxm.localnews.news.model.param.BasePostParam;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author liujia
 * @date 9/8/21 11:09 PM
 **/
@Api(tags = "9-04 帖子发布相关接口")
@RequestMapping("{version}/news/security/publish")
@RestController
@AllArgsConstructor
public class ForumPostPublishController {

    private PostCreateService postCreateService;

    private ForumPostService forumPostService;

    @ApiOperation(value = "9-04-1 [v1]发布或编辑帖子", notes = "发帖入口发帖或我的发布中进行编辑")
    @PostMapping(value = "save")
    @ApiVersion(1)
    public ResponseJson<ForumPostCreateDTO> createOrUpdatePost(@RequestBody ForumBasicVo forumBasicVo, BasicParam basicParam) {
        Message message = postCreateService.saveUserPost(forumBasicVo, basicParam, false);

        if (!message.isSuccess()) {
            return ResponseJson.badReqeuset(message.getLastMessage()).build();
        }

        ForumPostCreateDTO forumPostCreateDTO = message.getParam("completeTaskAndPush");
        if (forumPostCreateDTO == null) {
            forumPostCreateDTO = new ForumPostCreateDTO();
        }

        return ResponseJson.ok(forumPostCreateDTO);
    }

    @ApiOperation(value = "9-04-2 [v1]删除帖子", notes = "我的发布中进行删除(历史接口，注意传参方式)")
    @PostMapping(value = "delete")
    @ApiVersion(1)
    public ResponseJson delete(@RequestBody BasePostParam param) {
        Message message = forumPostService.deleteForumPost(param.getPostId());
        return ResponseJson.build(message);
    }
}
