package com.bxm.localnews.news.controller;

import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.comment.NewNewsReplyService;
import com.bxm.localnews.news.model.dto.NewsReplyDTO;
import com.bxm.localnews.news.model.dto.NewsReplyDetailDTO;
import com.bxm.localnews.news.model.dto.NewsReplyListDTO;
import com.bxm.localnews.news.model.dto.ReplyDTO;
import com.bxm.localnews.news.model.param.NewsReplyAddParam;
import com.bxm.localnews.news.model.param.NewsReplyLikeParam;
import com.bxm.localnews.news.model.param.NewsReplyParam;
import com.bxm.localnews.news.model.param.UserReplyParam;
import com.bxm.localnews.news.model.vo.MyReplysVO;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

@Api(tags = "9-07 评论相关接口")
@RequestMapping("{version}/news/reply")
@RestController
@AllArgsConstructor
public class ForumPostReplyController {

    private NewNewsReplyService newNewsReplyService;

    @ApiOperation(value = "9-07-1 [v1]获取帖子的全部评论，包括热评", notes = "根据业务id获取帖子的全部评论列表", httpMethod = "GET")
    @RequestMapping(value = "list", method = RequestMethod.GET)
    @ApiVersion(1)
    public ResponseJson<NewsReplyListDTO> replyList(NewsReplyParam newsReplyParam, BasicParam basicParam) {
        return ResponseJson.ok(newNewsReplyService.replyList(newsReplyParam, basicParam));
    }

    @ApiOperation(value = "9-07-2 [v1]用户发表的评论列表", notes = "不包含已删除的评论，包括新闻和视频", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "current", value = "当前页数[传这个参数],为了兼容前置版本，不改动此字段")
    })
    @RequestMapping(value = "security/my/list", method = RequestMethod.GET)
    @ApiVersion(1)
    public Json<PageWarper<MyReplysVO>> myReplys(UserReplyParam newsReplyParam,
                                                 @RequestParam(value = "current", required = false) Integer current,
                                                 BasicParam basicParam) {
        if (current == null) {
            current = 1;
        }
        newsReplyParam.setPageNum(current);
        return ResultUtil.genSuccessResult(this.newNewsReplyService.selectMyReplys(newsReplyParam, basicParam));
    }

    @ApiOperation(value = "9-07-3 [v1]用户发表点评", notes = "用户在新闻或视频发表点评，需要传字段标识类型", httpMethod = "POST")
    @RequestMapping(value = "security/publish", method = RequestMethod.POST)
    @ApiVersion(1)
    public Json<ReplyDTO> doReply(@RequestBody NewsReplyAddParam newsReplyParam) {
        return this.newNewsReplyService.doReply(newsReplyParam, newsReplyParam);
    }

    @ApiOperation(value = "9-07-4 [v1]删除我的评论", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "replyId", value = "回复id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = false)
    })
    @RequestMapping(value = "security/remove", method = RequestMethod.GET)
    @ApiVersion(1)
    public Json<NewsReplyDTO> delMyReply(@RequestParam(value = "replyId") Long replyId,
                                         @RequestParam(value = "userId") Long userId,
                                         @RequestParam(value = "newsId", required = false) Long newsId) {
        return Json.build(this.newNewsReplyService.delMyReply(replyId, userId, newsId, (byte) 1));
    }

    @ApiOperation(value = "9-07-5 [v1]对评论点赞", notes = "对留言进行点赞")
    @PostMapping("security/like")
    @ApiVersion(1)
    public Json likeReply(@RequestBody NewsReplyLikeParam param) {
        return Json.build(newNewsReplyService.doProduceNewsReplyLike(param));
    }

    @ApiOperation(value = "9-07-6 [v1]根据id获取评论详情", notes = "获取某条评论的详情，包括新闻标题,跳转地址,新闻图片")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "replyId", value = "回复ID", required = true),
            @ApiImplicitParam(name = "type", value = "类型 1：新闻 2：视频 3:帖子", required = true),
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = false)
    })
    @GetMapping("detail")
    @ApiVersion(1)
    public Json<NewsReplyDetailDTO> getReplyDetail(@RequestParam(value = "replyId") Long replyId,
                                                   @RequestParam(value = "userId") Long userId,
                                                   @RequestParam(value = "newsId", required = false) Long newsId,
                                                   @RequestParam(value = "areaCode", required = false) String areaCode,
                                                   BasicParam param) {
        return ResultUtil.genSuccessResult(newNewsReplyService.getNewsReplyDetailDTO(replyId, userId, newsId, areaCode, param));
    }


}
