package com.bxm.localnews.news.controller;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.model.vo.topic.TopicVo;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author liujia
 * @date 9/9/21 5:14 PM
 **/
@Api(tags = "9-05 社区话题相关接口")
@RestController
@RequestMapping("{version}/news/topic")
@AllArgsConstructor
public class ForumTopicController {

    private final ForumTopicService forumTopicService;

    @ApiOperation(value = "9-05-1 [v1]热门话题", notes = "获取热门话题", nickname = "pf.w")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码")
    })
    @GetMapping(value = "hotTopic")
    @ApiVersion(1)
    public ResponseJson<List<TopicVo>> getHotTopic(BaseAreaCodeParam param) {
        return ResponseJson.ok(forumTopicService.getHotTopicList(param.getAreaCode()));
    }

    @ApiOperation(value = "9-05-2 [v1]根据地区获取话题列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区", required = true),
            @ApiImplicitParam(name = "size", value = "展示数量(默认为-1表示展示全部)"),
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "postPage", value = "是否发帖页面, 0否1是")
    })
    @GetMapping(value = "getTopicListByArea")
    @ApiVersion(1)
    public Json<List<TopicVo>> getTopicListByArea(@RequestParam(value = "areaCode", required = false) String areaCode,
                                                  @RequestParam(value = "size", required = false) Integer size,
                                                  @RequestParam(value = "userId") Long userId,
                                                  @RequestParam(value = "postPage", required = false) Integer postPage) throws BindException {
        return ResultUtil.genSuccessResult(forumTopicService.listTopic(areaCode, size, userId, postPage));
    }

    @ApiOperation(value = "9-05-4 [v1]根据id获取话题", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码"),
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "type", value = "3.10.0  发帖按钮过来的type值  910001：随便聊聊    910002：本地爆料  为详情弹窗用 可为空")
    })
    @GetMapping(value = "getTopicById")
    @ApiVersion(1)
    public Json<TopicVo> getTopicById(Long id, Long userId, String areaCode, Integer type) {
        return ResultUtil.genSuccessResult(forumTopicService.getTopicDetailNew(id, userId, areaCode, type));
    }
}
