package com.bxm.localnews.news.controller;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.localnews.news.activity.GrainPostService;
import com.bxm.localnews.news.activity.GrainTotalService;
import com.bxm.localnews.news.model.dto.grain.GrainListDTO;
import com.bxm.localnews.news.model.dto.grain.GrainTotalListDTO;
import com.bxm.localnews.news.model.param.BasePostParam;
import com.bxm.localnews.news.model.param.GrainPromotionParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author liujia
 * @date 9/10/21 11:21 PM
 **/
@Api(tags = "9-08 开仓放粮帖相关接口")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/news/grain")
public class GrainPostController {

    private GrainPostService grainPostService;

    private GrainTotalService grainTotalService;

    @ApiOperation(value = "9-08-1 [v1]获取开仓放粮信息", notes = "包含开仓放粮的话题ID和对应的列表信息")
    @GetMapping("list")
    @ApiVersion(1)
    public ResponseJson<GrainListDTO> list(BaseAreaCodeParam param) {
        return ResponseJson.ok(grainPostService.recommendIndex(param));
    }

    @ApiOperation(value = "9-08-2 [v1]实现有效阅读后，给用户发粮食", notes = "如果返回400，则说明领取失败，返回的result为错误信息")
    @PostMapping("security/grant")
    @ApiVersion(1)
    public ResponseJson grant(@Valid @RequestBody BasePostParam param) {
        return ResponseJson.build(grainPostService.grant(param));
    }

    @ApiOperation(value = "9-08-3 [v1]保存付费推广信息", notes = "返回付费推广信息的ID，然后发起支付请求。如果返回为空或code为400，则说明重复")
    @PostMapping("security/save")
    @ApiVersion(1)
    public ResponseJson<Long> save(@Valid @RequestBody GrainPromotionParam param) {
        Message message = grainPostService.save(param);

        if (message.isSuccess()) {
            Long id = message.getParam("id");
            return ResponseJson.ok(id);
        } else {
            return ResponseJson.badReqeuset(message.getLastMessage()).build();
        }
    }

    @ApiOperation(value = "9-08-4 [v1]获取帖子推广数据", notes = "返回帖子推广数据列表")
    @GetMapping("security/queryActivityGrainTotal/{postId}")
    @ApiVersion(1)
    public ResponseJson<List<GrainTotalListDTO>> queryActivityGrainTotal(@PathVariable("postId") Long postId) {
        return ResponseJson.ok(grainTotalService.queryActivityGrainTotal(postId));
    }

}
