package com.bxm.localnews.news.controller;

import com.bxm.egg.common.param.BaseAreaCodeParam;
import com.bxm.localnews.news.model.dto.IndexPlusDTO;
import com.bxm.localnews.news.model.param.IndexPlusParam;
import com.bxm.localnews.news.model.vo.LocalCrumbs;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.localnews.news.service.LocalCircleService;
import com.bxm.localnews.news.service.PublishEntryService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/9/18 7:46 下午
 */
@Api(tags = "9-06 本地圈Tab相关接口")
@RestController
@AllArgsConstructor
@RequestMapping("{version}/news/local/circle")
public class LocalCircleController extends BaseController {

    private final LocalCircleService localCircleService;

    private final PublishEntryService publishEntryService;

    private final ForumPostService forumPostService;

    @ApiOperation(value = "9-06-01 [v1]获取本地圈话题广场面包块", notes = "本地圈顶部的话题广场面包块配置")
    @ApiVersion(1)
    @GetMapping(value = "getLocalCrumbsInfo")
    public ResponseJson<LocalCrumbs> getLocalCrumbsInfo(BaseAreaCodeParam param) {
        return ResponseJson.ok(localCircleService.getLocalCrumbsInfo(param.getUserId().toString(), param.getAreaCode()));
    }

    @ApiOperation(value = "9-06-02 [v1]上报点击面包块接口", notes = "点击话题广场后上报，清除已读数量")
    @GetMapping(value = "reportCrumbsInfo")
    @ApiVersion(1)
    public ResponseJson<Boolean> reportCrumbsInfo(BaseAreaCodeParam param) {
        return ResponseJson.ok(localCircleService.reportCrumbsInfo(param.getUserId(), param.getAreaCode(), 1));
    }

    @ApiOperation(value = "9-06-3 [v1]发帖入口相关的快捷链接配置", notes = "用户发帖页面显示的各种入口")
    @GetMapping("index")
    @ApiVersion(1)
    public ResponseJson<IndexPlusDTO> index(IndexPlusParam param) {
        return ResponseJson.ok(publishEntryService.index(param));
    }

    @ApiOperation(value = "9-06-4 [v1]本地圈是否有内容更新",
            notes = "在本地圈tab显示小红点。记录用户上次请求到现在是否有新的内容，客户端需要本地存储请求的时间戳")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "lastRequestTime", value = "当前客户端最后请求的时间", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
    })
    @GetMapping(value = "haveContentUpdate")
    @ApiVersion(1)
    public ResponseJson<Boolean> haveContentUpdate(Date lastRequestTime, String areaCode) {
        return ResponseJson.ok(forumPostService.getContentUpdate(lastRequestTime, areaCode));
    }
}