package com.bxm.localnews.news.deprecated;

import com.bxm.localnews.news.model.param.ReplyOperateParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.service.ForumPostSnapshotService;
import com.bxm.localnews.news.service.HotReplayService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 为手机端的运营操作提供快捷操作入口
 *
 * @author gonzo
 * @date 2021-02-25 15:35
 **/
@Api(tags = "4-19 帖子快照相关接口")
//@RestController
@RequestMapping("{version}/news/forumSnapshot")
@Deprecated
@AllArgsConstructor
public class ForumSnapshotController {

    private final ForumPostSnapshotService forumPostSnapshotService;

    private final HotReplayService hotReplayService;

    @GetMapping("getBySnapshotId")
    @ApiOperation(value = "4-19-1 [v1] 根据历史id查询帖子的历史快照", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "snapshotId", value = "快照id", required = true),
    })
    @ApiVersion(1)
    public ResponseJson<ForumPostVo> getBySnapshotId(Long snapshotId) {
        return ResponseJson.ok(forumPostSnapshotService.getSnapshotInfo(snapshotId));
    }

    @ApiOperation(value = "4-09-8 运营人员对帖子的操作接口", notes = "运营人员对帖子的操作接口", httpMethod = "POST", nickname = "wpf")
    @RequestMapping(value = "news/reply/operate", method = RequestMethod.POST)
    public ResponseJson<Boolean> replyOperate(@RequestBody ReplyOperateParam param) {
        return ResponseJson.ok(hotReplayService.operateReply(param));
    }
}
