package com.bxm.localnews.news.manage;

import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.model.param.EditorMessageParam;
import com.bxm.localnews.news.model.param.manage.IdParam;
import com.bxm.localnews.news.model.vo.BasicEditorMessage;
import com.bxm.localnews.news.post.EditorMessageService;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "9-04 [管理]编辑寄语管理", description = "编辑寄语相关接口")
@RestController
@RequestMapping("manage/news/editMessage")
public class AdminEditorMessageController {

    private final EditorMessageService editorMessageService;

    @Autowired
    public AdminEditorMessageController(EditorMessageService editorMessageService) {
        this.editorMessageService = editorMessageService;
    }

    @ApiOperation(value = "9-04-1 编辑寄语新增或修改", notes = "编辑寄语新增或修改")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "id", value = "模板id,新增时传0或者 null", required = true),
            @ApiImplicitParam(name = "content", value = "寄语内容", required = true),
            @ApiImplicitParam(name = "templateName", value = "寄语名称", required = true),
    })
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdateEditorMessage(@RequestBody EditorMessageParam editorMessageParam) {
        int result = editorMessageService.doSaveOrUpdateEditorMessage(editorMessageParam);
        if (result > 0) {
            return ResultUtil.genSuccessResult("保存成功!");
        }
        return ResultUtil.genFailedResult("保存失败");
    }

    @ApiOperation(value = "9-04-2 分页展示编辑寄语列表 ", notes = " 分页展示编辑寄语列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前是第几页", required = true),
            @ApiImplicitParam(name = "pageSize", value = "每页显示数量", required = true)
    })
    @GetMapping("listAll")
    public Json<PageWarper<BasicEditorMessage>> listAll(PageParam pageParam) {
        PageWarper<BasicEditorMessage> result = editorMessageService.listPage(pageParam);
        return ResultUtil.genSuccessResult(result);
    }

    @ApiOperation(value = "9-04-3 根据id删除编辑寄语", notes = "删除编辑寄语")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板id", required = true)
    })
    @PostMapping("deleteById")
    public Json deleteById(@RequestBody IdParam param) {
        int result = editorMessageService.deleteById(param.getId());
        if (result > 0) {
            return ResultUtil.genSuccessResult("删除成功!");
        }
        return ResultUtil.genFailedResult("删除失败");
    }


    @ApiOperation(value = "9-04-4 获得编辑寄语列表不分页", notes = "编辑寄语列表")
    @GetMapping("getAll")
    public Json<List<BasicEditorMessage>> getAll() {
        List<BasicEditorMessage> result = editorMessageService.listAll();
        return ResultUtil.genSuccessResult(result);
    }


}
