package com.bxm.localnews.news.manage;

import com.bxm.component.office.excel.export.impl.SimpleExcelExporter;
import com.bxm.component.office.excel.export.setting.ExcelSheet;
import com.bxm.component.office.excel.export.setting.ExportSetting;
import com.bxm.component.office.excel.export.setting.SheetHeader;
import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.localnews.news.approve.PostApproveService;
import com.bxm.localnews.news.create.PostCreateService;
import com.bxm.localnews.news.model.dto.AdminGetPostUrlDTO;
import com.bxm.localnews.news.model.param.AdminForumPostParam;
import com.bxm.localnews.news.model.param.manage.AddPostLikeParam;
import com.bxm.localnews.news.model.param.manage.DeleteOrRecoverParam;
import com.bxm.localnews.news.model.param.manage.PostApproveParam;
import com.bxm.localnews.news.model.vo.AdminBaseForumPostExcelVO;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminForumPostApproveHistory;
import com.bxm.localnews.news.post.AdminForumPostService;
import com.bxm.localnews.news.util.SecurityUtils;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import static com.bxm.newidea.component.tools.DateUtils.DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL;

@Api(tags = "9-01 [管理]帖子管理", description = "帖子管理")
@RestController
@RequestMapping("manage/news/forumPost")
@AllArgsConstructor
public class AdminForumPostController extends BaseController {

    private AdminForumPostService adminForumPostService;

    private PostLikeService postLikeService;

    private PostApproveService postApproveService;

    private PostCreateService postCreateService;

    @ApiOperation(value = "9-01-1 获取帖子审核列表")
    @GetMapping("/listApprove")
    public ResponseJson<IPageModel<AdminForumPost>> getApprovePostList(AdminForumPostParam param) {
        return ResponseJson.ok(adminForumPostService.getApproveList(param));
    }

    @ApiOperation(value = "9-01-2 获取帖子详情")
    @GetMapping("/detail")
    public ResponseJson<AdminForumPost> getForumPostById(Long id) {
        return ResponseJson.ok(adminForumPostService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "9-01-3 批量帖子审核")
    @PostMapping("approve")
    public ResponseJson approve(@Valid @RequestBody PostApproveParam param) {
        postApproveService.batchApprove(param.getIds(),
                param.getStatus(),
                param.getComment(),
                SecurityUtils.getAdminUserId());
        return ResponseJson.ok().build();
    }

    @ApiOperation(value = "9-01-4 新增或编辑帖子")
    @PostMapping("saveOrUpdate")
    public ResponseJson saveOrUpdate(@RequestBody AdminForumPost adminForumPost) {
        return ResponseJson.build(postCreateService.saveAdminPost(adminForumPost, SecurityUtils.getAdminUserId()));
    }

    @ApiOperation(value = "9-01-5 批量删除或恢复帖子")
    @PostMapping("deleteOrRecover")
    public ResponseJson<Integer> deleteOrRecover(@RequestBody DeleteOrRecoverParam param) {
        return ResponseJson.ok(adminForumPostService.deleteOrRecover(param.getIds(), param.getStatus(), param.getDeductGold()));
    }

    @ApiOperation(value = "9-01-6 获取新增帖子id")
    @ApiImplicitParam(name = "postType", value = "帖子类型,3:活动帖子，其他：社区帖子")
    @GetMapping("/getCreateId")
    public ResponseJson<Long> getCreateId(@RequestParam(value = "postType", required = false) Integer postType) {
        return ResponseJson.ok(adminForumPostService.getCreateId(postType));
    }

    @ApiOperation(value = "9-01-7 获取帖子审核历史列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "action", value = "审批动作：0拒绝，1通过")
    })
    @GetMapping("/listApproveHistory")
    public ResponseJson<List<AdminForumPostApproveHistory>> getApproveHistoryList(Long id, Integer action) {
        return ResponseJson.ok(postApproveService.getApproveHistoryList(id, action));
    }


    @ApiOperation(value = "9-01-9 增加帖子马甲号点赞", notes = "帖子马甲号点赞")
    @PostMapping("/addPostLike")
    public ResponseJson addPostLike(@Valid @RequestBody AddPostLikeParam param) {
        postLikeService.doAddPostLike(param);
        return ResponseJson.ok().build();
    }

    @ApiOperation(value = "9-01-10 判断帖子列表中是否存在现金奖励贴")
    @ApiImplicitParam(name = "ids", value = "帖子ID列表")
    @GetMapping("hasCashPost")
    public ResponseJson<Boolean> hasCashPost(String ids) {
        return ResponseJson.ok(adminForumPostService.hasCashPost(ids));
    }


    @ApiOperation(value = "9-01-12 获取链接")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "区域编码", required = true),
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "cityName", value = "区域名称", required = true),
            @ApiImplicitParam(name = "type", value = "0-短链 1-长链接 2-站内链接", required = true),
            @ApiImplicitParam(name = "channel", value = "预留字段-渠道名称，现在默认是wx"),
    })
    @GetMapping("getPostUrl")
    public ResponseJson<String> getPostUrl(@ApiIgnore AdminGetPostUrlDTO adminGetPostUrlDTO) {
        return ResponseJson.ok(adminForumPostService.getPostUrl(adminGetPostUrlDTO));
    }

    @ApiOperation(value = "9-01-13 获取帖子列表文件（此方法将返回文件流）")
    @GetMapping("listApprove/excel")
    public ResponseJson getApprovePostListExcel(AdminForumPostParam param, HttpServletResponse response) throws IOException {
        Date maxBefore = DateUtils.addField(new Date(), Calendar.DAY_OF_MONTH, -30);
        if (Objects.isNull(param.getPublishStartTime())) {
            // 设置30天之前
            param.setPublishStartTime(maxBefore);
        } else {
            if (param.getPublishStartTime().before(maxBefore)) {
                return ResponseJson.badReqeuset("不允许下载30天之前的帖子").build();
            }
        }

        // 查询数据
        param.setPageNum(null);
        param.setPageSize(null);
        List<AdminBaseForumPostExcelVO> approveList = adminForumPostService.getApproveListExcelVO(param);

        SimpleExcelExporter excelExporter = SpringContextHolder.getBean(SimpleExcelExporter.class);

        ExportSetting setting = new ExportSetting();
        ExcelSheet excelSheet = setting.addSheet();
        excelSheet.setDataCollection(approveList);
        excelSheet.setFreezeHeader(true);
        excelSheet.setSheetName("帖子列表");
        excelSheet.setDefaultWidth(30);

        excelSheet.addHeader(new SheetHeader(("帖子id"), "id"));
        excelSheet.addHeader(new SheetHeader(("帖子标题"), "title"));
        excelSheet.addHeader(new SheetHeader(("发帖地址"), "location"));
        excelSheet.addHeader(new SheetHeader(("发帖区域编码"), "areaCode"));
        excelSheet.addHeader(new SheetHeader(("帖子文本"), "textField"));
        excelSheet.addHeader(new SheetHeader(("作者id"), "userId"));
        excelSheet.addHeader(new SheetHeader(("作者名称"), "userName"));
        excelSheet.addHeader(new SheetHeader(("是否精华帖"), "isBrilliant"));
        excelSheet.addHeader(new SheetHeader(("是否推荐（是否优质头条）"), "isRecommend"));
        excelSheet.addHeader(new SheetHeader(("是否红色章"), "isRed"));
        excelSheet.addHeader(new SheetHeader(("是否奖励现金"), "isCash"));
        excelSheet.addHeader(new SheetHeader(("现金奖励金额"), "cashReward"));
        excelSheet.addHeader(new SheetHeader(("是否本地爆料"), "isBroke"));
        excelSheet.addHeader(new SheetHeader(("创建时间"), "createTime"));
        excelSheet.addHeader(new SheetHeader(("定时发布时间"), "publishTime"));
        excelSheet.addHeader(new SheetHeader(("展示时间"), "displayTime"));
        excelSheet.addHeader(new SheetHeader(("帖子状态"), "status"));
        excelSheet.addHeader(new SheetHeader(("发布区域类型"), "deliveryType"));
        excelSheet.addHeader(new SheetHeader(("帖子类型"), "postType"));
        excelSheet.addHeader(new SheetHeader(("有效期"), "validDay"));
        excelSheet.addHeader(new SheetHeader(("到期时间"), "validDate"));
        excelSheet.addHeader(new SheetHeader(("发帖区域"), "areaDetail"));
        excelSheet.addHeader(new SheetHeader(("话题id列表"), "topicIdList"));
        excelSheet.addHeader(new SheetHeader(("更新时间"), "modifyTime"));
        excelSheet.addHeader(new SheetHeader(("发帖人身份"), "identity"));
        excelSheet.addHeader(new SheetHeader(("是否过期"), "isValid"));

        processDownload(DATE_TIME_SECONDMS_FORMAT_THREAD_LOCAL.get().format(new Date()) + "帖子批量导出.xls", response);
        excelExporter.export(response.getOutputStream(), setting);

        return ResponseJson.build();
    }

    @ApiOperation(value = "9-01-14 获取开仓放粮的帖子列表")
    @GetMapping("/listGrainApprove")
    public ResponseJson<IPageModel<AdminForumPost>> getGrainPostList(AdminForumPostParam param) {
        return ResponseJson.ok(adminForumPostService.getApproveGrainList(param));
    }
}

