package com.bxm.localnews.news.manage;

import com.bxm.localnews.news.model.param.ForumSnapshotInfo;
import com.bxm.localnews.news.service.ForumPostSnapshotService;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author gonzo
 * @date 2021-02-25 16:51
 **/
@Api(tags = "9-02 [管理]运营后台帖子快照相关接口")
@RestController
@RequestMapping("manage/news/forumSnapshot")
@AllArgsConstructor
public class AdminForumSnapshotController {

    private final ForumPostSnapshotService forumPostSnapshotService;

    @ApiOperation(value = "9-02-1 获取帖子的快照列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "帖子id", required = true),
    })
    @GetMapping("listSnapshots")
    public ResponseJson<List<ForumSnapshotInfo>> listSnapshots(Long newsId) {
        return ResponseJson.ok(forumPostSnapshotService.listSnapshots(newsId));
    }
}
