package com.bxm.localnews.news.manage;

import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.comment.NewNewsReplyService;
import com.bxm.localnews.news.model.dto.AdminReplyDTOAdmin;
import com.bxm.localnews.news.model.dto.AdminReplyDetailDTO;
import com.bxm.localnews.news.model.param.*;
import com.bxm.localnews.news.model.param.manage.RemoveReplayParam;
import com.bxm.localnews.news.model.vo.AdminNewsReply;
import com.bxm.localnews.news.service.AdminNewsReplyService;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Api(tags = "9-08 [管理]新闻管理中评论管理", description = "新闻评论管理，包括新闻评论的模拟生成，添加，删除")
@RestController
@RequestMapping("manage/news/reply")
public class AdminNewsReplyController {

    private final AdminNewsReplyService adminNewsReplyService;

    private final NewNewsReplyService newNewsReplyService;

    @Autowired
    public AdminNewsReplyController(AdminNewsReplyService adminNewsReplyService,
                                    NewNewsReplyService newNewsReplyService) {
        this.adminNewsReplyService = adminNewsReplyService;
        this.newNewsReplyService = newNewsReplyService;
    }

    @ApiOperation("9-08-1 模拟评论生成")
    @PostMapping("/virtual")
    public Json generate(@RequestBody AdminNewsReplyOriginalParam adminNewsReplyOriginalParam) {
        if (adminNewsReplyOriginalParam.getNewsId() != null) {
            return this.adminNewsReplyService.doGenerateReply(adminNewsReplyOriginalParam);
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

    @ApiOperation("9-08-2 新闻下评论分页")
    @GetMapping("/list")
    public Json<PageWarper<AdminNewsReply>> queryPage(AdminNewsReplyParam adminNewsReplyParam) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.listNewsReply(adminNewsReplyParam));
    }

    @ApiOperation("9-08-3 评论删除")
    @PostMapping("/del")
    public Json del(@RequestBody RemoveReplayParam param) {
        if (param.getNewsId() != null) {
            this.newNewsReplyService.delReply(param.getReplyId(), param.getNewsId());
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

    @ApiOperation("9-08-4 增加评论回复")
    @PostMapping("/addCommentReply")
    public Json addCommentReply(@RequestBody AdminCommentReplyParam adminCommentReplyParam) {
        int result = adminNewsReplyService.doAddCommentReply(adminCommentReplyParam);
        return ResultUtil.genSuccessMsg("添加评论成功");

    }

    @ApiOperation("9-08-5 评论分页")
    @GetMapping("/allList")
    public Json<PageWarper<AdminReplyDTOAdmin>> queryAllList(AdminAllReplyParam adminAllReplyParam) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.listAllNewsReply(adminAllReplyParam));
    }

    @ApiOperation("9-08-6 评论详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true),
            @ApiImplicitParam(name = "replyId", value = "评论id", required = true),
    })
    @GetMapping("/getReplyDetail")
    public Json<AdminReplyDetailDTO> getReplyDetail(Long newsId, Long replyId) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.getReplyDetail(newsId, replyId));
    }

    @ApiOperation("'9-08-7 帖子评论状态管理")
    @PostMapping("statusChange")
    public ResponseJson statusChange(@RequestBody ReplyStatusChangeParam param) {
        return ResponseJson.build(adminNewsReplyService.statusChange(param));
    }

}

