package com.bxm.localnews.news.manage;

import com.bxm.egg.common.utils.ResultUtil;
import com.bxm.egg.common.vo.Json;
import com.bxm.localnews.news.model.param.AdminReplyLibraryCategoryParam;
import com.bxm.localnews.news.model.param.manage.IdParam;
import com.bxm.localnews.news.model.vo.AdminReplyLibraryCategory;
import com.bxm.localnews.news.service.AdminReplyLibraryCategoryService;
import com.bxm.localnews.news.vo.PageWarper;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "9-06 [管理]评论库类别管理", description = "评论库类别管理")
@RestController
@RequestMapping("manage/news/replyLibraryCategory")
public class AdminReplyLibraryCategoryController extends BaseController {

    @Resource
    private AdminReplyLibraryCategoryService adminReplyLibraryCategoryService;

    @ApiOperation(value = "9-06-1 获取评论库类别列表")
    @GetMapping("list")
    public Json<PageWarper<AdminReplyLibraryCategory>> getList(AdminReplyLibraryCategoryParam param) {
        return ResultUtil.genSuccessResult(adminReplyLibraryCategoryService.getList(param));
    }

    @ApiOperation(value = "9-06-2 获取评论库类别详情")
    @GetMapping("detail")
    public Json<AdminReplyLibraryCategory> selectByPrimaryKey(Long id) {
        return ResultUtil.genSuccessResult(adminReplyLibraryCategoryService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "9-06-3 新增评论库类别")
    @PostMapping("insert")
    public Json insert(@RequestBody AdminReplyLibraryCategory adminReplyLibraryCategory) {
        return ResultUtil.genSuccessResult(adminReplyLibraryCategoryService.insert(adminReplyLibraryCategory));
    }

    @ApiOperation(value = "9-06-4 编辑评论库类别")
    @PostMapping("updateByPrimaryKey")
    public Json updateByPrimaryKey(@RequestBody AdminReplyLibraryCategory adminReplyLibraryCategory) {
        return ResultUtil.genSuccessResult(adminReplyLibraryCategoryService.updateByPrimaryKey(adminReplyLibraryCategory));
    }

    @ApiOperation(value = "9-06-5 删除评论库类别")
    @PostMapping("deleteByPrimaryKey")
    public Json deleteByPrimaryKey(@RequestBody IdParam param) {
        return ResultUtil.genSuccessResult(adminReplyLibraryCategoryService.deleteByPrimaryKey(param.getId()));
    }

}

